/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.common.Util;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import spana.ProgramDataSpana;
import spana.SpanaFrame;

public class DiagrExport
extends JFrame {
    private ProgramConf pc;
    private ProgramDataSpana pd;
    private boolean finished = false;
    private Dimension windowSize;
    private String pltFileFullName;
    private String convertedFileFullN;
    private File convertedFile;
    private double height2width = Double.NaN;
    private boolean loading = true;
    private boolean cancel = true;
    private String exportType = "png";
    private int exportSize = 1000;
    private static final String nl = System.getProperty("line.separator");
    private ButtonGroup buttonGroupO;
    private JButton jButtonDoIt;
    private JComboBox jComboBoxType;
    private JLabel jLabelDir;
    private JLabel jLabelDirName;
    private JLabel jLabelFont;
    private JLabel jLabelOut;
    private JLabel jLabelOutputName;
    private JLabel jLabelPltFile;
    private JLabel jLabelPltFileName;
    private JLabel jLabelSize;
    private JLabel jLabel_H;
    private JLabel jLabel_W;
    private JLabel jLabel_h;
    private JLabel jLabel_w;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelBottom;
    private JPanel jPanelSize;
    private JPanel jPanelTop;
    private JPanel jPanelType;
    private JScrollBar jScrollBarWidth;

    public DiagrExport(ProgramConf pc0, ProgramDataSpana pd0, double heightToWidth) {
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.height2width = heightToWidth;
        this.finished = false;
        this.cancel = true;
        this.loading = true;
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrExport.this.closeWindow();
            }
        };
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrExport.this.jButtonDoIt.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrExport.this.setCursor(new Cursor(3));
                String[] a = new String[]{"S_Printing_htm_BMP"};
                RunProgr.runProgramInProcess((Component)DiagrExport.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((DiagrExport)DiagrExport.this).pc.dbg, (String)((DiagrExport)DiagrExport.this).pc.pathAPP);
                DiagrExport.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        this.windowSize = this.getSize();
        int left = Math.max(55, (SpanaFrame.screenSize.width - this.windowSize.width) / 2);
        int top = Math.max(10, (SpanaFrame.screenSize.height - this.windowSize.height) / 2);
        this.setLocation(Math.min(SpanaFrame.screenSize.width - 100, left), Math.min(SpanaFrame.screenSize.height - 100, top));
        this.setTitle("Export a diagram:");
        String iconName = "images/Icon-Export_24x24.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            System.err.println("--- Error in DiagrExport constructor: Could not load image = \"" + iconName + "\"");
        }
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        for (String ex : SpanaFrame.FORMAT_NAMES) {
            if (ex.length() <= 0) continue;
            dcbm.addElement(ex);
        }
        this.jComboBoxType.setModel(dcbm);
        this.exportType = this.pd.diagrExportType;
        this.exportSize = this.pd.diagrExportSize;
        for (int i = 0; i < dcbm.getSize(); ++i) {
            if (!dcbm.getElementAt(i).toString().equalsIgnoreCase(this.exportType)) continue;
            this.jComboBoxType.setSelectedIndex(i);
            break;
        }
        this.jButtonDoIt.setText("export to " + this.exportType.toUpperCase());
        this.jLabelPltFileName.setText(" ");
        this.jLabelDirName.setText(this.pc.pathDef.toString());
        this.exportSize = Math.max(5, Math.min(this.jScrollBarWidth.getMaximum(), this.exportSize));
        this.jScrollBarWidth.setValue(this.exportSize);
        if (this.height2width < 1.0) {
            this.jScrollBarWidth.setMinimum((int)(11.0 / this.height2width));
            this.jLabel_W.setText(String.valueOf((int)((double)this.exportSize)));
            this.jLabel_H.setText(String.valueOf((int)((double)this.exportSize * this.height2width)));
        } else {
            this.jScrollBarWidth.setMinimum((int)(11.0 * this.height2width));
            this.jLabel_W.setText(String.valueOf((int)((double)this.exportSize / this.height2width)));
            this.jLabel_H.setText(String.valueOf((int)((double)this.exportSize)));
        }
    }

    public boolean start(String pltFileN) {
        if (this.pc.dbg) {
            System.out.println(" - - - - - - DiagrExport");
        }
        this.setVisible(true);
        if (pltFileN == null || pltFileN.trim().length() <= 0) {
            String msg = "Programming Error: empty or null file name in DiagrExport.";
            Util.exceptn((String)msg);
            JOptionPane.showMessageDialog(this, msg, "Programming error", 0);
            this.closeWindow();
            return false;
        }
        File pltFile = new File(pltFileN);
        String msg = null;
        if (!pltFile.exists()) {
            msg = "the file does not exist.";
        }
        if (!pltFile.canRead()) {
            msg = "can not open file for reading.";
        }
        if (msg != null) {
            String t = "Error: \"" + pltFileN + "\"" + nl + msg;
            Util.exceptn((String)t);
            JOptionPane.showMessageDialog(this, t, this.pc.progName, 0);
            this.closeWindow();
            return false;
        }
        try {
            this.pltFileFullName = pltFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                this.pltFileFullName = pltFile.getAbsolutePath();
            }
            catch (Exception e) {
                this.pltFileFullName = pltFile.getPath();
            }
        }
        this.setTitle(pltFile.getName());
        this.jLabelPltFileName.setText(pltFile.getName());
        this.jLabelDirName.setText(pltFile.getParent());
        this.convertedFileFullN = Div.getFileNameWithoutExtension((String)this.pltFileFullName) + "." + this.exportType.toLowerCase();
        this.convertedFile = new File(this.convertedFileFullN);
        this.jLabelOutputName.setText(this.convertedFile.getName());
        int k = this.getWidth() - this.jPanelBottom.getWidth();
        this.validate();
        int j = Math.max(this.jPanelBottom.getWidth(), this.jPanelTop.getWidth());
        Dimension d = new Dimension(k + j, this.getHeight());
        this.setSize(d);
        this.loading = false;
        return true;
    }

    private void initComponents() {
        this.buttonGroupO = new ButtonGroup();
        this.jPanelTop = new JPanel();
        this.jLabelPltFile = new JLabel();
        this.jLabelPltFileName = new JLabel();
        this.jLabelDir = new JLabel();
        this.jLabelDirName = new JLabel();
        this.jPanelType = new JPanel();
        this.jLabelFont = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jPanelSize = new JPanel();
        this.jLabelSize = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel_h = new JLabel();
        this.jLabel_w = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel_H = new JLabel();
        this.jLabel_W = new JLabel();
        this.jScrollBarWidth = new JScrollBar();
        this.jPanelBottom = new JPanel();
        this.jLabelOut = new JLabel();
        this.jLabelOutputName = new JLabel();
        this.jButtonDoIt = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DiagrExport.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DiagrExport.this.formComponentResized(evt);
            }
        });
        this.jPanelTop.setFont(new Font("Dialog", 0, 11));
        this.jLabelPltFile.setFont(new Font("Dialog", 0, 11));
        this.jLabelPltFile.setText("Plot file:");
        this.jLabelPltFileName.setFont(new Font("Dialog", 1, 12));
        this.jLabelPltFileName.setText("Hello.plt");
        this.jLabelDir.setFont(new Font("Dialog", 0, 11));
        this.jLabelDir.setText("Directory: ");
        this.jLabelDirName.setFont(new Font("Dialog", 0, 11));
        this.jLabelDirName.setText("\"D:\\myfiles\\subdir");
        GroupLayout jPanelTopLayout = new GroupLayout(this.jPanelTop);
        this.jPanelTop.setLayout(jPanelTopLayout);
        jPanelTopLayout.setHorizontalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.jLabelPltFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPltFileName)).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.jLabelDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDirName))).addGap(0, 0, Short.MAX_VALUE)));
        jPanelTopLayout.setVerticalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPltFile).addComponent(this.jLabelPltFileName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDir).addComponent(this.jLabelDirName))));
        this.jPanelType.setFont(new Font("Dialog", 0, 11));
        this.jLabelFont.setFont(new Font("Dialog", 0, 11));
        this.jLabelFont.setText("Export image as:");
        this.jComboBoxType.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrExport.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanelTypeLayout = new GroupLayout(this.jPanelType);
        this.jPanelType.setLayout(jPanelTypeLayout);
        jPanelTypeLayout.setHorizontalGroup(jPanelTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTypeLayout.createSequentialGroup().addComponent(this.jLabelFont).addGap(0, 20, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelTypeLayout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelTypeLayout.setVerticalGroup(jPanelTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTypeLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabelFont).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelSize.setFont(new Font("Dialog", 0, 11));
        this.jLabelSize.setFont(new Font("Dialog", 0, 11));
        this.jLabelSize.setText("Image size (pixels):");
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel_h.setFont(new Font("Dialog", 0, 11));
        this.jLabel_h.setText("height:");
        this.jLabel_w.setFont(new Font("Dialog", 0, 11));
        this.jLabel_w.setText("widtht:");
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel_H.setFont(new Font("Dialog", 0, 11));
        this.jLabel_H.setText("2000");
        this.jLabel_W.setFont(new Font("Dialog", 0, 11));
        this.jLabel_W.setText("3000");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_W, GroupLayout.Alignment.LEADING, -1, 65, Short.MAX_VALUE).addComponent(this.jLabel_H, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_H).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.jLabel_W)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_h).addComponent(this.jLabel_w)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel_h).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_w)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.jScrollBarWidth.setMaximum(2010);
        this.jScrollBarWidth.setMinimum(20);
        this.jScrollBarWidth.setOrientation(0);
        this.jScrollBarWidth.setValue(1000);
        this.jScrollBarWidth.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                DiagrExport.this.jScrollBarWidthAdjustmentValueChanged(evt);
            }
        });
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSize).addGroup(jPanelSizeLayout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollBarWidth, -2, 113, -2).addComponent(this.jPanel2, -2, -1, -2))));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addComponent(this.jLabelSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollBarWidth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2)));
        this.jPanelBottom.setFont(new Font("Dialog", 0, 11));
        this.jLabelOut.setFont(new Font("Dialog", 0, 11));
        this.jLabelOut.setText("Output file:");
        this.jLabelOutputName.setFont(new Font("Dialog", 1, 12));
        this.jLabelOutputName.setText("Hello.pdf");
        GroupLayout jPanelBottomLayout = new GroupLayout(this.jPanelBottom);
        this.jPanelBottom.setLayout(jPanelBottomLayout);
        jPanelBottomLayout.setHorizontalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBottomLayout.createSequentialGroup().addComponent(this.jLabelOut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelOutputName).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelBottomLayout.setVerticalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBottomLayout.createSequentialGroup().addGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutputName).addComponent(this.jLabelOut)).addGap(8, 8, 8)));
        this.jButtonDoIt.setFont(new Font("Dialog", 0, 11));
        this.jButtonDoIt.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Icon-Export_24x24.gif")));
        this.jButtonDoIt.setMnemonic('e');
        this.jButtonDoIt.setText("export to ...");
        this.jButtonDoIt.setIconTextGap(8);
        this.jButtonDoIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrExport.this.jButtonDoItActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelBottom, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelTop, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDoIt).addGroup(layout.createSequentialGroup().addComponent(this.jPanelType, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanelSize, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelTop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelSize, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelType, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelBottom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDoIt).addContainerGap(30, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonDoItActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.pd.diagrExportType = this.exportType;
        this.pd.diagrExportSize = this.exportSize;
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jScrollBarWidthAdjustmentValueChanged(AdjustmentEvent evt) {
        this.exportSize = this.jScrollBarWidth.getValue();
        if (this.height2width < 1.0) {
            this.jLabel_W.setText(String.valueOf((int)((double)this.exportSize)));
            this.jLabel_H.setText(String.valueOf((int)((double)this.exportSize * this.height2width)));
        } else {
            this.jLabel_W.setText(String.valueOf((int)((double)this.exportSize / this.height2width)));
            this.jLabel_H.setText(String.valueOf((int)((double)this.exportSize)));
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        if (!this.loading) {
            this.exportType = this.jComboBoxType.getSelectedItem().toString();
            this.jButtonDoIt.setText("export to " + this.exportType.toUpperCase());
            this.convertedFileFullN = Div.getFileNameWithoutExtension((String)this.pltFileFullName) + "." + this.exportType.toLowerCase();
            this.convertedFile = new File(this.convertedFileFullN);
            this.jLabelOutputName.setText(this.convertedFile.getName());
        }
    }

    public final void closeWindow() {
        this.finished = true;
        this.setVisible(false);
        this.dispose();
        this.notify_All();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized boolean waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.cancel;
    }
}

