/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import spana.Disp;

public class DiagrWSize
extends JDialog {
    private boolean finished = false;
    private DiagrWSize frame = null;
    private Disp d = null;
    private Dimension windowSize;
    private final int h0;
    private final int w0;
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelH;
    private JLabel jLabelName;
    private JLabel jLabelW;
    private JTextField jTextFieldH;
    private JTextField jTextFieldW;

    public DiagrWSize(Frame parent, boolean modal, Disp diagr0) {
        super(parent, modal);
        this.initComponents();
        this.d = diagr0;
        this.finished = false;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrWSize.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrWSize.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        this.setTitle(" Diagram size");
        this.jLabelName.setText("Diagram: \"" + this.d.diagrName + "\"");
        this.h0 = Math.round((float)this.d.diagrSize.getHeight());
        this.jTextFieldH.setText(String.valueOf(this.h0).trim());
        this.w0 = Math.round((float)this.d.diagrSize.getWidth());
        this.jTextFieldW.setText(String.valueOf(this.w0).trim());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagrWSize.this.frame = DiagrWSize.this;
                DiagrWSize.this.windowSize = DiagrWSize.this.frame.getSize();
                int left = Math.max(0, DiagrWSize.this.d.getX() + DiagrWSize.this.d.getWidth() / 2 - DiagrWSize.this.frame.getWidth() / 2);
                int top = Math.max(0, DiagrWSize.this.d.getY() + DiagrWSize.this.d.getHeight() / 2 - DiagrWSize.this.frame.getHeight() / 2);
                DiagrWSize.this.frame.setLocation(left, top);
            }
        });
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jLabelName = new JLabel();
        this.jLabelW = new JLabel();
        this.jTextFieldW = new JTextField();
        this.jLabelH = new JLabel();
        this.jTextFieldH = new JTextField();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DiagrWSize.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DiagrWSize.this.formComponentResized(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("<html><u>O</u>K</html>");
        this.jButtonOK.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonOK.setMinimumSize(new Dimension(47, 23));
        this.jButtonOK.setPreferredSize(new Dimension(47, 23));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrWSize.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelName.setFont(new Font("Dialog", 0, 11));
        this.jLabelName.setText("Diagram: \"hello\"");
        this.jLabelW.setFont(new Font("Dialog", 0, 11));
        this.jLabelW.setLabelFor(this.jTextFieldW);
        this.jLabelW.setText("width:");
        this.jTextFieldW.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldW.setText("1000");
        this.jTextFieldW.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiagrWSize.this.jTextFieldWFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiagrWSize.this.jTextFieldWFocusLost(evt);
            }
        });
        this.jTextFieldW.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DiagrWSize.this.jTextFieldWKeyTyped(evt);
            }
        });
        this.jLabelH.setFont(new Font("Dialog", 0, 11));
        this.jLabelH.setLabelFor(this.jTextFieldH);
        this.jLabelH.setText("height:");
        this.jTextFieldH.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldH.setText("1000");
        this.jTextFieldH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiagrWSize.this.jTextFieldHFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiagrWSize.this.jTextFieldHFocusLost(evt);
            }
        });
        this.jTextFieldH.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DiagrWSize.this.jTextFieldHKeyTyped(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('C');
        this.jButtonCancel.setText("<html><u>C</u>ancel</html>");
        this.jButtonCancel.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrWSize.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelName).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelH).addComponent(this.jLabelW)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldH, -2, 55, -2).addComponent(this.jTextFieldW, -2, 55, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 47, -2).addGap(38, 38, 38).addComponent(this.jButtonCancel, -2, -1, -2))).addContainerGap(38, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabelName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldW, -2, -1, -2).addComponent(this.jLabelW)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldH, -2, -1, -2).addComponent(this.jLabelH)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK, -2, -1, -2).addComponent(this.jButtonCancel, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int w;
        int h;
        try {
            h = Integer.parseInt(this.jTextFieldH.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.toString(), "Diagram Size - Error", 0);
            h = this.h0;
        }
        try {
            w = Integer.parseInt(this.jTextFieldW.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.toString(), "Diagram Size - Error", 0);
            w = this.w0;
        }
        this.d.diagrSize.setSize(w, h);
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void jTextFieldWKeyTyped(KeyEvent evt) {
        if (!Character.isDigit(evt.getKeyChar())) {
            evt.consume();
        }
    }

    private void jTextFieldHKeyTyped(KeyEvent evt) {
        if (!Character.isDigit(evt.getKeyChar())) {
            evt.consume();
        }
    }

    private void jTextFieldWFocusLost(FocusEvent evt) {
        try {
            int w = Integer.parseInt(this.jTextFieldW.getText());
            this.jTextFieldW.setText(String.valueOf(w).trim());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Wrong numeric format" + nl + nl + "Please enter an integer.", "Numeric Format Error", 2);
            int w = this.w0;
            this.jTextFieldW.setText(String.valueOf(w));
            this.jTextFieldW.requestFocus();
        }
    }

    private void jTextFieldHFocusLost(FocusEvent evt) {
        try {
            int h = Integer.parseInt(this.jTextFieldH.getText());
            this.jTextFieldH.setText(String.valueOf(h).trim());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Wrong numeric format" + nl + nl + "Please enter an integer.", "Numeric Format Error", 2);
            int h = this.h0;
            this.jTextFieldH.setText(String.valueOf(h));
            this.jTextFieldH.requestFocus();
        }
    }

    private void jTextFieldWFocusGained(FocusEvent evt) {
        this.jTextFieldW.selectAll();
    }

    private void jTextFieldHFocusGained(FocusEvent evt) {
        this.jTextFieldH.selectAll();
    }

    private void closeWindow() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

