/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import spana.ProgramDataSpana;
import spana.SpanaFrame;

public class OptionsCalcs
extends JFrame {
    private boolean finished = false;
    private Dimension windowSize;
    private double tolHalta = 1.0E-5;
    private ProgramDataSpana pd;
    private ProgramConf pc;
    private int calcDbgHalta = 0;
    private int actCoeffsMethod;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JCheckBox jCheckBoxCalcsDbg;
    private JCheckBox jCheckBoxKeep;
    private JComboBox jComboBoxChar;
    private JComboBox jComboBoxDbgH;
    private JComboBox jComboBoxExt;
    private JComboBox jComboBoxTol;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelChar;
    private JLabel jLabelDbgH;
    private JLabel jLabelExt;
    private JLabel jLabelMinVal;
    private JLabel jLabelTol;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanelTable;
    private JScrollBar jScrollBarMin;
    private JTextField jTextF_End;
    private JTextField jTextF_Start;

    public OptionsCalcs(ProgramConf pc0, ProgramDataSpana pd0) {
        int i;
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.finished = false;
        this.windowSize = this.getSize();
        int left = Math.max(55, (SpanaFrame.screenSize.width - this.windowSize.width) / 2);
        int top = Math.max(10, (SpanaFrame.screenSize.height - this.windowSize.height) / 2);
        this.setLocation(Math.min(SpanaFrame.screenSize.width - 100, left), Math.min(SpanaFrame.screenSize.height - 100, top));
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.setCursor(new Cursor(3));
                String[] a = new String[]{"S_Menu_Prefs_htm_Calcs"};
                RunProgr.runProgramInProcess((Component)OptionsCalcs.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((OptionsCalcs)OptionsCalcs.this).pc.dbg, (String)((OptionsCalcs)OptionsCalcs.this).pc.pathAPP);
                OptionsCalcs.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.jButton_OK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke altDKeyStroke = KeyStroke.getKeyStroke(68, 8, false);
        this.getRootPane().getInputMap(2).put(altDKeyStroke, "ALT_D");
        AbstractAction altDAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.jComboBoxDbgH.requestFocusInWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_D", altDAction);
        KeyStroke altTKeyStroke = KeyStroke.getKeyStroke(84, 8, false);
        this.getRootPane().getInputMap(2).put(altTKeyStroke, "ALT_T");
        AbstractAction altTAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.jComboBoxTol.requestFocusInWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_T", altTAction);
        KeyStroke altEKeyStroke = KeyStroke.getKeyStroke(69, 8, false);
        this.getRootPane().getInputMap(2).put(altEKeyStroke, "ALT_E");
        AbstractAction altEAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.jComboBoxExt.requestFocusInWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_E", altEAction);
        KeyStroke altCKeyStroke = KeyStroke.getKeyStroke(67, 8, false);
        this.getRootPane().getInputMap(2).put(altCKeyStroke, "ALT_C");
        AbstractAction altCAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCalcs.this.jComboBoxChar.requestFocusInWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_C", altCAction);
        this.setTitle("Calculation Options:");
        String iconName = "images/Wrench_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            System.err.println("Error: Could not load image = \"" + iconName + "\"");
        }
        this.jCheckBoxCalcsDbg.setSelected(this.pd.calcDbg);
        this.calcDbgHalta = Math.max(0, Math.min(this.jComboBoxDbgH.getItemCount() - 1, this.pd.calcDbgHalta));
        this.jComboBoxDbgH.setSelectedIndex(this.calcDbgHalta);
        this.tolHalta = this.pd.tolHalta;
        this.set_tol_inComboBox();
        for (String tblExtension_type : this.pd.tblExtension_types) {
            this.jComboBoxExt.addItem(tblExtension_type);
        }
        boolean found = false;
        for (i = 0; i < this.jComboBoxExt.getItemCount(); ++i) {
            if (!this.jComboBoxExt.getItemAt(i).toString().equalsIgnoreCase(this.pd.tblExtension)) continue;
            this.jComboBoxExt.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            this.jComboBoxExt.setSelectedIndex(0);
        }
        for (i = 0; i < this.pd.tblFieldSeparator_types.length; ++i) {
            String t = this.pd.tblFieldSeparator_types[i] == ';' ? "; (semicolon)" : (this.pd.tblFieldSeparator_types[i] == ',' ? ", (comma)" : (this.pd.tblFieldSeparator_types[i] == ' ' ? "  (space)" : (this.pd.tblFieldSeparator_types[i] == '\t' ? "\\t (tab)" : "(error)")));
            this.jComboBoxChar.addItem(t);
        }
        found = false;
        String c = this.pd.tblFieldSeparator == '\t' ? "\\t" : Character.toString(this.pd.tblFieldSeparator) + " ";
        for (int i2 = 0; i2 < this.jComboBoxChar.getItemCount(); ++i2) {
            if (!this.jComboBoxChar.getItemAt(i2).toString().substring(0, 2).equalsIgnoreCase(c)) continue;
            this.jComboBoxChar.setSelectedIndex(i2);
            found = true;
            break;
        }
        if (!found) {
            this.jComboBoxChar.setSelectedIndex(0);
        }
        this.jScrollBarMin.setValue(Math.round(this.pd.fractionThreshold * 1000.0f));
        this.jScrollBarMinAdjustmentValueChanged(null);
        this.jScrollBarMin.setFocusable(true);
        this.jCheckBoxKeep.setSelected(this.pd.keepFrame);
        if (this.pd.tblCommentLineStart != null && this.pd.tblCommentLineStart.length() > 0) {
            this.jTextF_Start.setText(this.pd.tblCommentLineStart);
        } else {
            this.jTextF_Start.setText("");
        }
        if (this.pd.tblCommentLineEnd != null && this.pd.tblCommentLineEnd.length() > 0) {
            this.jTextF_End.setText(this.pd.tblCommentLineEnd);
        } else {
            this.jTextF_End.setText("");
        }
        this.checkBoxKeep();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBoxKeep = new JCheckBox();
        this.jCheckBoxCalcsDbg = new JCheckBox();
        this.jLabelDbgH = new JLabel();
        this.jComboBoxDbgH = new JComboBox();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.jLabelTol = new JLabel();
        this.jComboBoxTol = new JComboBox();
        this.jPanel10 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollBarMin = new JScrollBar();
        this.jLabelMinVal = new JLabel();
        this.jPanelTable = new JPanel();
        this.jLabelExt = new JLabel();
        this.jComboBoxExt = new JComboBox();
        this.jLabelChar = new JLabel();
        this.jComboBoxChar = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextF_End = new JTextField();
        this.jTextF_Start = new JTextField();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionsCalcs.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                OptionsCalcs.this.formComponentResized(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, " Debugging: ", 0, 0, new Font("Dialog", 1, 11), new Color(51, 0, 255)));
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxKeep.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxKeep.setMnemonic('K');
        this.jCheckBoxKeep.setText("Keep windows open after calculations");
        this.jCheckBoxKeep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsCalcs.this.jCheckBoxKeepActionPerformed(evt);
            }
        });
        this.jCheckBoxCalcsDbg.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxCalcsDbg.setMnemonic('W');
        this.jCheckBoxCalcsDbg.setText("Write messages in SED & Predom");
        this.jLabelDbgH.setFont(new Font("Dialog", 0, 11));
        this.jLabelDbgH.setLabelFor(this.jComboBoxDbgH);
        this.jLabelDbgH.setText("<html><u>D</u>ebugging in HaltaFall:</html>");
        this.jComboBoxDbgH.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxDbgH.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - none", "1 - errors only", "2 - errors + results", "3 - errors + results + input", "4 = 3 + output from Fasta", "5 = 4 + output from activity coeffs.", "6 = 5 + lots of output"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxKeep).addComponent(this.jCheckBoxCalcsDbg))).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDbgH, -2, 216, -2).addComponent(this.jLabelDbgH, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxKeep).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCalcsDbg).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelDbgH, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDbgH, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_OK.setFont(new Font("Dialog", 0, 11));
        this.jButton_OK.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/OK_32x32.gif")));
        this.jButton_OK.setMnemonic('O');
        this.jButton_OK.setText("OK");
        this.jButton_OK.setToolTipText("OK (Alt-O orAlt-X)");
        this.jButton_OK.setHorizontalAlignment(2);
        this.jButton_OK.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsCalcs.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setFont(new Font("Dialog", 0, 11));
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Trash.gif")));
        this.jButton_Cancel.setMnemonic('Q');
        this.jButton_Cancel.setText("Quit");
        this.jButton_Cancel.setToolTipText("Cancel (Esc or Alt-Q)");
        this.jButton_Cancel.setHorizontalAlignment(2);
        this.jButton_Cancel.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsCalcs.this.jButton_CancelActionPerformed(evt);
            }
        });
        this.jLabelTol.setFont(new Font("Dialog", 0, 11));
        this.jLabelTol.setLabelFor(this.jComboBoxTol);
        this.jLabelTol.setText("<html>Max. <u>t</u>olerance for mass-balance eqns. in HaltaFall:</html>");
        this.jComboBoxTol.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxTol.setModel(new DefaultComboBoxModel<String>(new String[]{"1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8", "1E-9"}));
        this.jPanel10.setFont(new Font("Dialog", 0, 11));
        this.jLabel4.setFont(new Font("Dialog", 0, 11));
        this.jLabel4.setText("Fraction diagrams: threshold for curves:");
        this.jScrollBarMin.setFont(new Font("Dialog", 0, 11));
        this.jScrollBarMin.setMinimum(1);
        this.jScrollBarMin.setOrientation(0);
        this.jScrollBarMin.setValue(0);
        this.jScrollBarMin.setVisibleAmount(0);
        this.jScrollBarMin.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                OptionsCalcs.this.jScrollBarMinAdjustmentValueChanged(evt);
            }
        });
        this.jScrollBarMin.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OptionsCalcs.this.jScrollBarMinFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OptionsCalcs.this.jScrollBarMinFocusLost(evt);
            }
        });
        this.jLabelMinVal.setFont(new Font("Dialog", 0, 11));
        this.jLabelMinVal.setText("0");
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jScrollBarMin, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMinVal, -2, 15, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMinVal, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollBarMin, -2, -1, -2)));
        this.jPanelTable.setBorder(BorderFactory.createTitledBorder(null, " Table output in SED: ", 0, 0, new Font("Dialog", 1, 11), new Color(51, 0, 255)));
        this.jPanelTable.setFont(new Font("Dialog", 0, 11));
        this.jLabelExt.setFont(new Font("Dialog", 0, 11));
        this.jLabelExt.setLabelFor(this.jComboBoxExt);
        this.jLabelExt.setText("<html>Name <u>e</u>xtension for output file:</html>");
        this.jComboBoxExt.setFont(new Font("Dialog", 0, 11));
        this.jLabelChar.setFont(new Font("Dialog", 0, 11));
        this.jLabelChar.setLabelFor(this.jComboBoxChar);
        this.jLabelChar.setText("<html><u>C</u>olumn-separation character:</html>");
        this.jComboBoxChar.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Comment-lines:");
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setLabelFor(this.jTextF_Start);
        this.jLabel3.setText("start characters:");
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setLabelFor(this.jTextF_End);
        this.jLabel2.setText("end characters:");
        this.jTextF_End.setFont(new Font("Dialog", 0, 11));
        this.jTextF_End.setText("\"");
        this.jTextF_End.setToolTipText("Text that will be appended at the end of any comment line");
        this.jTextF_End.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OptionsCalcs.this.jTextF_EndFocusGained(evt);
            }
        });
        this.jTextF_Start.setFont(new Font("Dialog", 0, 11));
        this.jTextF_Start.setText("\"");
        this.jTextF_Start.setToolTipText("Text that will be inserted before any comment line");
        this.jTextF_Start.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OptionsCalcs.this.jTextF_StartFocusGained(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextF_End).addComponent(this.jTextF_Start)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextF_Start, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextF_End, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelTableLayout = new GroupLayout(this.jPanelTable);
        this.jPanelTable.setLayout(jPanelTableLayout);
        jPanelTableLayout.setHorizontalGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTableLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelExt, -2, -1, -2).addComponent(this.jLabelChar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxChar, -2, 114, -2).addComponent(this.jComboBoxExt, -2, 92, -2)).addContainerGap()).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        jPanelTableLayout.setVerticalGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTableLayout.createSequentialGroup().addGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExt, -2, -1, -2).addComponent(this.jComboBoxExt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTableLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxChar, -2, -1, -2).addComponent(this.jLabelChar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel10, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelTable, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton_Cancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_OK, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabelTol, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxTol, -2, 82, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jButton_OK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Cancel)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTol, -2, -1, -2).addComponent(this.jComboBoxTol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel10, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelTable, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this.pd.keepFrame = this.jCheckBoxKeep.isSelected();
        this.pd.calcDbg = this.jCheckBoxCalcsDbg.isSelected();
        this.pd.calcDbgHalta = Integer.parseInt(this.jComboBoxDbgH.getSelectedItem().toString().substring(0, 2).trim());
        String t = this.jComboBoxTol.getSelectedItem().toString();
        try {
            this.pd.tolHalta = Double.parseDouble(t);
        }
        catch (NumberFormatException ex) {
            System.err.println("Error: trying to read a number in \"" + t + "\"");
            this.pd.tolHalta = 1.0E-5;
        }
        this.pd.tblExtension = this.jComboBoxExt.getSelectedItem().toString();
        t = this.jComboBoxChar.getSelectedItem().toString().substring(0, 2);
        this.pd.tblFieldSeparator = t.equalsIgnoreCase("\\t") ? (char)9 : t.charAt(0);
        t = this.jTextF_Start.getText();
        this.pd.tblCommentLineStart = t != null && t.length() > 0 ? t : "";
        t = this.jTextF_End.getText();
        this.pd.tblCommentLineEnd = t != null && t.length() > 0 ? t : "";
        this.pd.fractionThreshold = (float)this.jScrollBarMin.getValue() / 1000.0f;
        this.closeWindow();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jCheckBoxKeepActionPerformed(ActionEvent evt) {
        this.checkBoxKeep();
    }

    private void jTextF_StartFocusGained(FocusEvent evt) {
        this.jTextF_Start.selectAll();
    }

    private void jTextF_EndFocusGained(FocusEvent evt) {
        this.jTextF_End.selectAll();
    }

    private void jScrollBarMinAdjustmentValueChanged(AdjustmentEvent evt) {
        this.jLabelMinVal.setText(String.valueOf((float)this.jScrollBarMin.getValue() / 10.0f) + "%");
    }

    private void jScrollBarMinFocusGained(FocusEvent evt) {
        this.jScrollBarMin.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
    }

    private void jScrollBarMinFocusLost(FocusEvent evt) {
        this.jScrollBarMin.setBorder(null);
    }

    private void closeWindow() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkBoxKeep() {
        if (this.jCheckBoxKeep.isSelected()) {
            this.jCheckBoxCalcsDbg.setEnabled(true);
            this.jLabelDbgH.setEnabled(true);
            this.jLabelDbgH.setText("<html><u>D</u>ebugging in HaltaFall:</html>");
            this.jComboBoxDbgH.setEnabled(true);
        } else {
            this.jCheckBoxCalcsDbg.setEnabled(false);
            this.jLabelDbgH.setText("Debugging in HaltaFall:");
            this.jLabelDbgH.setEnabled(false);
            this.jComboBoxDbgH.setEnabled(false);
        }
    }

    private void set_tol_inComboBox() {
        int listItem = 0;
        int listCount = this.jComboBoxTol.getItemCount();
        for (int i = 1; i < listCount; ++i) {
            double w0 = Double.parseDouble(this.jComboBoxTol.getItemAt(i - 1).toString());
            double w1 = Double.parseDouble(this.jComboBoxTol.getItemAt(i).toString());
            if (this.tolHalta >= w0 && i == 1) {
                listItem = 0;
                break;
            }
            if (this.tolHalta <= w1 && i == listCount - 1) {
                listItem = listCount - 1;
                break;
            }
            if (!(this.tolHalta < w0) || !(this.tolHalta >= w1)) continue;
            if (Math.abs(this.tolHalta - w0) < Math.abs(this.tolHalta - w1)) {
                listItem = i - 1;
                break;
            }
            listItem = i;
            break;
        }
        this.jComboBoxTol.setSelectedIndex(listItem);
    }
}

