/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.util.ArrayList;

public class CSVparser {
    private static final String nl = System.getProperty("line.separator");

    public static ArrayList<String> splitLine(String line) throws CSVdataException {
        if (line == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        OneRes or = new OneRes();
        for (int pos = 0; pos < line.length(); ++pos) {
            pos = CSVparser.findNextComma(pos, line, or);
            al.add(or.oneRes);
        }
        if (line.length() > 0 && (line.charAt(line.length() - 1) == ',' || line.charAt(line.length() - 1) == ';')) {
            al.add("");
        }
        return al;
    }

    public static ArrayList<String> splitLine_N(String line, int n) throws CSVdataException {
        if (line == null || n <= 0) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>(n);
        if (n == 1) {
            al.add(CSVparser.splitLine_1(line));
            return al;
        }
        OneRes or = new OneRes();
        int size = 0;
        for (int pos = 0; pos < line.length(); ++pos) {
            pos = CSVparser.findNextComma(pos, line, or);
            al.add(or.oneRes);
            if (++size < n) continue;
        }
        if (size <= n - 1) {
            for (int i = size; i < n; ++i) {
                al.add("");
            }
        }
        return al;
    }

    public static String splitLine_1(String line) throws CSVdataException {
        if (line == null) {
            return null;
        }
        OneRes or = new OneRes();
        CSVparser.findNextComma(0, line, or);
        return or.oneRes;
    }

    private static int findNextComma(int p, String line, OneRes or) throws CSVdataException {
        or.oneRes = "";
        char c = line.charAt(p);
        while (Character.isWhitespace(c)) {
            if (++p >= line.length()) {
                or.oneRes = "";
                return p;
            }
            c = line.charAt(p);
        }
        if (c == ',' || c == ';') {
            or.oneRes = "";
            return p;
        }
        if (c != '\"' && c != '\'') {
            int i = line.length();
            int j = line.indexOf(44, p);
            int k = line.indexOf(59, p);
            if (j > -1 && j < i) {
                i = j;
            }
            if (k > -1 && k < i) {
                i = k;
            }
            or.oneRes = line.substring(p, i).trim();
            return i;
        }
        int k = p++;
        char quote = c;
        StringBuilder sb = new StringBuilder(200);
        while (true) {
            if (p >= line.length()) {
                throw new CSVdataException("Error: missing closing quote in line" + nl + "   " + line + nl + "in text: " + quote + sb.toString() + "  (starting at position " + (k + 1) + ")");
            }
            c = line.charAt(p);
            ++p;
            if (c != quote) {
                sb.append(c);
                continue;
            }
            if (p == line.length()) {
                or.oneRes = sb.toString();
                return p;
            }
            c = line.charAt(p);
            ++p;
            if (c != quote) break;
            sb.append(quote);
        }
        while (Character.isWhitespace(c)) {
            if (p >= line.length()) {
                or.oneRes = sb.toString();
                return p;
            }
            c = line.charAt(p);
            ++p;
        }
        if (c == ',' || c == ';') {
            or.oneRes = sb.toString();
            return p - 1;
        }
        throw new CSVdataException("Unexpected token found in line:" + nl + "   " + line + nl + "token: " + quote + sb.toString() + quote + "  (starting at position " + (k + 1) + ")");
    }

    public static class CSVdataException
    extends Exception {
        public CSVdataException() {
        }

        public CSVdataException(String txt) {
            super(txt);
        }
    }

    private static class OneRes {
        String oneRes = "";
    }
}

