/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.pict;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.SortablePolygon;
import org.qenherkhopeshef.graphics.pict.MacPictDeviceContext;
import org.qenherkhopeshef.graphics.utils.GeometryUtils;

public class MacPictGraphics2D
extends BaseGraphics2D {
    private MacPictDeviceContext deviceContext;
    private double deviceScale = 28.444444444444443;
    private int level = 0;
    private double precision = 0.05;

    public MacPictGraphics2D() {
        this.deviceContext = new MacPictDeviceContext();
    }

    public MacPictGraphics2D(double minx, double miny, double maxx, double maxy) {
        MacPictDeviceContext.MPPoint p0 = this.deviceCoords(new Point2D.Double(minx, miny));
        MacPictDeviceContext.MPPoint p1 = this.deviceCoords(new Point2D.Double(maxx, maxy));
        this.deviceContext = new MacPictDeviceContext(p0.x, p0.y, p1.x, p1.y);
    }

    public MacPictGraphics2D(MacPictGraphics2D graphics2D) {
        super(graphics2D);
        this.deviceContext = graphics2D.deviceContext;
        this.level = graphics2D.level + 1;
    }

    public int getDpi() {
        return this.deviceContext.getDpi();
    }

    public void setDpi(int dpi) {
        this.deviceContext.setDpi(dpi);
    }

    public void setPictureClip(double minx, double miny, double maxx, double maxy) {
        Point2D.Double p1a = new Point2D.Double(minx, miny);
        Point2D.Double p2a = new Point2D.Double(maxx, maxy);
        MacPictDeviceContext.MPPoint p1 = this.deviceCoords(p1a);
        MacPictDeviceContext.MPPoint p2 = this.deviceCoords(p2a);
        this.deviceContext.setClipBox(p1.x, p1.y, p2.x, p2.y);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new MacPictGraphics2D(this);
    }

    public void dispose() {
        if (this.level == 0) {
            this.deviceContext.closePicture();
        }
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void fill(Shape shape) {
        double[] coords = new double[6];
        Color paintColor = this.getColor();
        if (this.getPaint() instanceof Color) {
            paintColor = (Color)this.getPaint();
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)shape;
            MacPictDeviceContext.MPPoint topLeft = this.deviceCoords(r.getMinX(), r.getMinY());
            MacPictDeviceContext.MPPoint bottomRight = this.deviceCoords(r.getMaxX(), r.getMaxY());
            this.deviceContext.setForegroundColor(MacPictGraphics2D.build48bitColor(this.getColor()));
            this.deviceContext.paintRectangle(topLeft, bottomRight);
        } else {
            Area shapeAsArea = new Area(shape);
            PathIterator iter = shapeAsArea.getPathIterator(null, this.precision);
            ArrayList<List> polygons = new ArrayList<List>();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            while (!iter.isDone()) {
                int type = iter.currentSegment(coords);
                switch (type) {
                    case 4: {
                        polygons.add(points);
                        points = new ArrayList();
                        break;
                    }
                    case 3: {
                        int i;
                        for (i = 0; i < 6; i += 2) {
                            points.add(new Point2D.Double(coords[i], coords[i + 1]));
                        }
                        break;
                    }
                    case 1: {
                        points.add(new Point2D.Double(coords[0], coords[1]));
                        break;
                    }
                    case 0: {
                        if (!points.isEmpty()) {
                            polygons.add(points);
                            points = new ArrayList();
                        }
                        points.add(new Point2D.Double(coords[0], coords[1]));
                        break;
                    }
                    case 2: {
                        int i;
                        for (i = 0; i < 4; i += 2) {
                            points.add(new Point2D.Double(coords[i], coords[i + 1]));
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected constant in path iterator");
                    }
                }
                iter.next();
            }
            if (!points.isEmpty()) {
                polygons.add(points);
                points = null;
            }
            if (!polygons.isEmpty()) {
                double area = 0.0;
                Object[] sortablePolygons = new SortablePolygon[polygons.size()];
                for (int i = 0; i < polygons.size(); ++i) {
                    List pts = (List)polygons.get(i);
                    sortablePolygons[i] = new SortablePolygon(pts);
                    area += GeometryUtils.algebricArea(pts);
                }
                Arrays.sort(sortablePolygons);
                for (int k = 0; k < sortablePolygons.length; ++k) {
                    polygons.set(k, ((SortablePolygon)sortablePolygons[k]).points);
                }
                MacPictDeviceContext.MPColor fillColor = MacPictGraphics2D.build48bitColor(paintColor);
                MacPictDeviceContext.MPColor unfillColor = MacPictGraphics2D.build48bitColor(this.getBackground());
                if (area < 0.0) {
                    fillColor = MacPictGraphics2D.build48bitColor(this.getBackground());
                    unfillColor = MacPictGraphics2D.build48bitColor(paintColor);
                }
                Iterator i = polygons.iterator();
                while (i.hasNext()) {
                    List pts = (List)i.next();
                    if (GeometryUtils.algebricArea(pts) > 0.0) {
                        this.fillPolygon(pts, fillColor);
                        continue;
                    }
                    this.fillPolygon(pts, unfillColor);
                }
            }
        }
    }

    private void fillPolygon(List pts, MacPictDeviceContext.MPColor fillColor) {
        if (pts.isEmpty()) {
            return;
        }
        MacPictDeviceContext.MPPoint[] poly = new MacPictDeviceContext.MPPoint[pts.size()];
        for (int i = 0; i < poly.length; ++i) {
            poly[i] = this.deviceCoords((Point2D)pts.get(i));
        }
        this.deviceContext.setForegroundColor(fillColor);
        this.deviceContext.fillPoly(poly);
    }

    public void setPaintMode() {
    }

    public void setProperties(Properties properties) {
    }

    public void setXORMode(Color c1) {
    }

    private MacPictDeviceContext.MPPoint deviceCoords(double x, double y) {
        return this.deviceCoords(new Point2D.Double(x, y));
    }

    private MacPictDeviceContext.MPPoint deviceCoords(Point2D p) {
        Point2D.Double res = new Point2D.Double();
        this.getTransform().transform(p, res);
        return new MacPictDeviceContext.MPPoint((short)(((Point2D)res).getX() * this.deviceScale), (short)(((Point2D)res).getY() * this.deviceScale));
    }

    private static MacPictDeviceContext.MPColor build48bitColor(Color color) {
        return new MacPictDeviceContext.MPColor(color.getRed() << 8, color.getGreen() << 8, color.getBlue() << 8);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        this.deviceContext.writeToStream(outputStream);
    }

    public byte[] getAsArray() {
        return this.deviceContext.getAsArray();
    }

    public byte[] getAsArrayForRTF() {
        return this.deviceContext.getAsArrayForRTF();
    }
}

