function [ J ] = func_compute_J_D_bar_fast( X, v, N, D, c, H, Q_inv )
%% I/O
%Standard Fisher information matrix
% Input: theta and v


%% Initialization
%Dimension of eta
T = N*D + (N-1) + 1;
T_theta = N*D;
T_delta = N-1;


K = N*(N-1)/2;

%Number of measurements
M = size(H,1);

%Allocate
J = zeros(T,T);


%% Loop

for i = 1:T
    for j = 1:T
       
        if (i == T) && (j == T)
            
            %Compute element for the covariance
            J(i,j) = J(i,j) + M/(2*v^2);
            
        elseif (i ~= T) && (j ~= T)
            
            %d g / d eta_i
            if (i <= T_theta)
               dg_i = [func_compute_drho_fast(X,i,N,D,H);  zeros(T_delta,1)];
            else
               dg_i    = zeros(K+T_delta,1);
               dg_i(K+i-T_theta) = 1;
            end
            
            %d g / d eta_i        j
            if (j <= T_theta)
               dg_j = [func_compute_drho_fast(X,j,N,D,H);  zeros(T_delta,1)];
            else
               dg_j    = zeros(K+T_delta,1);
               dg_j(K+j-T_theta) = 1;
            end
            
            %DISP
            %disp([i j])
            %disp(dg_j)
            %disp('-------')
            %disp(size(dg_i))
            %disp(size(dg_j))
            
            
            %Compute element for the mean
            J(i,j) =  J(i,j) + (H*dg_i)' * Q_inv * (H*dg_j) / (v * c^2);
            
        end
        
        
    end 
end


end




function [drho] = func_compute_drho_fast(P_aug,theta_idx,N,D, S_b)


%% Initialize
K    = N*(N-1)/2; %number of node-to-node ranges
drho = sparse(K,1);

%% Loop

for k = 1 : K,
   if sum( S_b(:,k) ~= 0 ) > 0
       %Compute derivative wrt. theta_idx
       drho(k,1) = func_compute_derivative( k, theta_idx, P_aug, N, D );
   end
end

end


function [drho_k] = func_compute_derivative( rho_idx, theta_idx, P_aug, N, D)

    %Map indices: rho_k -> node p, q
    [ node_p, node_q ] = func_invmap_idx( rho_idx, N );
    
    %Map indices: theta_j -> node r, dimension d
    [ node_r, dim_d ] = func_map_theta_idx( theta_idx, D );
    
    %Identify elements
    if (node_r ~= node_p) && (node_r ~= node_q) 
        drho_k = 0;
    else
        %Obtain data
        x_p = P_aug(:,node_p);
        x_q = P_aug(:,node_q);
        
        drho_k = (x_p(dim_d) - x_q(dim_d)) / norm(x_p-x_q);
        
        if (node_r ~= node_p) && (node_r == node_q)
            drho_k = -drho_k;
        end
        
    end
    
    
    

end

