function [H, Q] = func_create_matrices_self( T, n, c )
%Dave Zachariah 2012-11-06


%% Initalize
%Integers
N     = max(T)+1;
K     = N*(N-1)/2; %# ranges
K_tot = K + (N-1);
M     = length(T) - 1; %# measurements

%Matrices
H = sparse(M,K_tot);
Q = sparse(M,M);


%% %Create matrices

for m = 1:M
    
    %Identify nodes
    node_i = T(m);
    node_j = T(m+1);
    
    %Identify scenario
    H(m,1:K_tot) = sparse(1,K_tot); %initial
    
    if (n~=node_i) && (n~=node_j)
        %Case: indirect measurement
        
        %Observation
        [idx_ij] = func_map_idx( node_i, node_j, N );
        H(m,idx_ij) = 1;
        
        [idx_jn] = func_map_idx( node_j, n, N );
        H(m,idx_jn) = 1;
        
        [idx_in] = func_map_idx( node_i, n, N );
        H(m,idx_in) = -1;
        
        %Delay
        H(m,K+node_j) = c;
        
        Q(m,m)   = 3;
            
    else 
       disp('Error: creating H')
    end
    
end




end

%----------------------------------
% ADDITIONAL FUNCTIONS
%----------------------------------


function [ idx ] = func_map_idx( node_a, node_b, N )
% Dave Zachariah 2012-08-22


%% Order
if node_a < node_b
   node_i = node_a;
   node_j = node_b;
else
    node_i = node_b;
    node_j = node_a;
end

%% Set index
idx = 0;

for l = 1:node_i-1
    idx = idx + (N-l);
end

idx = idx + node_j-node_i;

end
