function [ vartheta_hat, sigma2_hat, count_conv_first, mean_inner_loop ] = func_iterativeMAP_seq_batch_alt_fast( mu, y, S, N, D, P, tol_theta, c, B, Q_inv, X_true, N_a )
%% I/O
%Dave Zachariah & Alessio De Angelis
% Input: prior mean and inverse-covariance matrix of positions
% Output: position estimates

%% Initalize

%Global variables
global T
global N_theta
global K
global Gamma_rho
global Gamma

%Constants
T       = length(mu);
K       = N * (N - 1)/2; %number of node-to-node ranges
M       = length(y);
N_theta = D*N;
I_T     = eye(T);

%Allocate memory
vartheta_hat_old = mu;
vartheta_tilde   = zeros(T,1);
P_old       = P;
Gamma_rho        = zeros(K,N_theta);
Gamma            = blkdiag( Gamma_rho, eye(N-1));



%% Sequential batch

count_conv_vec = zeros(length(B:B:M),1);
error_abs = [];

for m = B:B:M,

    %Iterative solution
    %----------------------------
    y_b = y(m-B+1:m);
    S_b = S(m-B+1:m,:);
    [vartheta_hat, P, count_conv_vec(floor(m/B)), mean_inner_vec(floor(m/B))] = ...
        func_seqAMAP( y_b, S_b, vartheta_hat_old, P_old, c,  N, D, mu, tol_theta, X_true, N_a );    

    
    
    % Update estimator
    %----------------------------
    vartheta_hat_old              = vartheta_hat;
    P_old                         = P;
    
    
end


%% Output
vartheta_hat = vartheta_hat_old;
count_conv_first = count_conv_vec(1);
mean_inner_loop = mean(mean_inner_vec);

%rho_hat    = func_compute_rho(vartheta_hat(1:N_theta), N, D);
%sigma2_hat = beta * norm(y - 1/c*S*[rho_hat; vartheta_hat(N_theta+1:end)])^2;
sigma2_hat = 0; % dummy, for compatibility reasons

return
end


%------------------------
% Additional functions
%------------------------

function [vartheta_hat_b, P_b, count_conv, mean_inner] = ...
    func_seqAMAP( y_b, S_b, vartheta_hat_bm1, P_bm1, c, N, D, mu, tol_theta, X_true, N_a )

global Gamma
%global T
global N_theta
global K
global gamma
global I_B
%global beta

%Variables
B              = length(y_b);
I_B            = eye(B);
gamma          = B+2;
vartheta_hat_b = vartheta_hat_bm1;

%% Iterate
count_conv = 1; % for plotting convergence histogram
error_abs = [];
count_conv_inner_vec = [];
while (true)
    
    
           
    %Evaluate g(vartheta)
    %------------------------------------
    rho = func_compute_rho( vartheta_hat_b, N, D );    
    g   = [rho; vartheta_hat_b(N_theta+1:end)];
        
    %Evaluate Jacobian of g
    Gamma_rho = func_compute_Gamma_rho( vartheta_hat_b, N, D, S_b  );
    Gamma(1:K,1:N_theta) = Gamma_rho;
    
    %Solve theta step
    %------------------------------------
    warning off
    [vartheta_tilde, inner_loop_conv_flag, count_conv_inner] = func_compute_vartheta_step( y_b, S_b, c, g, vartheta_hat_b, ...
                                                                         vartheta_hat_bm1, P_bm1 );
    warning on
    
    count_conv_inner_vec = [count_conv_inner_vec count_conv_inner];
    
    % if inner loop does not converge, keeping current estimate
    if inner_loop_conv_flag == 1,
        disp('keeping current estimate');
        vartheta_hat_b
        break;
    end
    
    %Update mth estimate
    vartheta_hat_b = vartheta_hat_b + vartheta_tilde;    
    
    %Termination criterion
    %------------------------------------
    Thresh_1 = 100; %maximum distance [m]
    if norm(vartheta_tilde(1:N_theta)) < tol_theta
        break;
    elseif norm(vartheta_tilde(1:N_theta)) > (Thresh_1*N)
        for n = 1:N
           %Check node n
           if norm(vartheta_tilde(D*(n-1)+1:D*(n-1)+D)) > Thresh_1
               vartheta_hat_b(D*(n-1)+1:D*(n-1)+D) = mu(D*(N-1)+1:D*(N-1)+D);
           end
        end
        break;
    elseif (count_conv > 1000)
        disp('Outer loop did not converge, keeping current estimate')
        norm_conv_criterion = norm(vartheta_tilde(1:N_theta)) % DEBUG: convergence study
        vartheta_hat_b = vartheta_hat_b % just for displaying purposes
        break;
    end
    
    count_conv = count_conv + 1;

            
end


%% Update information matrix

%Evaluate observation model
rho       = func_compute_rho( vartheta_hat_b, N, D );
g         = [rho; vartheta_hat_b(N_theta+1:end)];
Gamma_rho = func_compute_Gamma_rho( vartheta_hat_b, N, D, S_b );
Gamma(1:K,1:N_theta) = Gamma_rho;

%Noise variance estimate
sigma2_hat = norm(y_b - S_b*g / c)^2 / (B+2);

%Covariance matrix update
G_b = S_b * Gamma / c;
P_b = P_bm1  -  P_bm1 * G_b'* (( G_b * P_bm1 * G_b' +  sigma2_hat * I_B ) \ G_b) * P_bm1;

%convergence analysis: compute average inner loop
mean_inner = mean(count_conv_inner_vec);

end


function [ rho ] = func_compute_rho( vartheta, N, D )

global N_theta

X   = reshape(vartheta(1:N_theta), D, N)';
rho = pdist(X, 'euclidean')';

end


function [Gamma_rho] = func_compute_Gamma_rho( vartheta, N, D, S_b )

%Global variables
global N_theta
global K

%Allocate
Gamma_rho = sparse(K,N_theta);

%Reshape
P_aug = reshape(vartheta(1:N_theta), D, N);

%Construct G
for j = 1:N_theta
     Gamma_rho(:,j) = func_compute_drho_fast(P_aug,j,N,D,  S_b );
end



end


function [vartheta_tilde, inner_loop_conv_flag, count_conv_inner] = func_compute_vartheta_step( y_b, S_b, c, g, vartheta_hat_b, vartheta_hat_bm1, P_bm1 ) 

%Global variables
global T
global Gamma
global gamma
global N_theta
global I_B

%Initialize
vartheta_tilde     = zeros(T,1);
vartheta_tilde_old = vartheta_tilde;
y_b_tilde          = y_b - S_b*g/c;
z                  = vartheta_hat_bm1 - vartheta_hat_b;
G                  = S_b*Gamma / c;

inner_loop_conv_flag = 0;

%% Loop
tol_theta = 1e-2 * N_theta; 
% tol_theta = 1e-2 * N_theta / 1000; % for plotting
count_conv_inner = 1;
norm_vartheta_tilde = [];
while(true)


    %Compute D-matrix
    kappa = norm(y_b_tilde - G*vartheta_tilde)^2;
    
    %Compute theta step
    vartheta_tilde = z + gamma*P_bm1 * G' * (( gamma*G*P_bm1*G' + kappa*I_B) \ ( y_b_tilde  -  G*z ));
 
    %Compute delta
    delta_theta_tilde = norm(vartheta_tilde(1:N_theta) - vartheta_tilde_old(1:N_theta) );
        
    %Update
    vartheta_tilde_old = vartheta_tilde;
    
    %Termination criterion
    if delta_theta_tilde < tol_theta
%     if delta_delta_tilde < tol_delta
        %disp('Inner loop converged')
        break;
    elseif (count_conv_inner > 1000)
        disp('Inner loop did not converge')
        inner_loop_conv_flag = 1;
        break;
    end
    
    count_conv_inner = count_conv_inner + 1;
    
end

end




function [drho] = func_compute_drho_fast(P_aug,theta_idx,N,D, S_b)


%% Initialize
K    = N*(N-1)/2; %number of node-to-node ranges
drho = sparse(K,1);

%% Loop

for k = 1 : K,
   if sum( S_b(:,k) ~= 0 ) > 0
       %Compute derivative wrt. theta_idx
       drho(k,1) = func_compute_derivative( k, theta_idx, P_aug, N, D );
   end
end

end


function [drho_k] = func_compute_derivative( rho_idx, theta_idx, P_aug, N, D)

    %Map indices: rho_k -> node p, q
    [ node_p, node_q ] = func_invmap_idx( rho_idx, N );
    
    %Map indices: theta_j -> node r, dimension d
    [ node_r, dim_d ] = func_map_theta_idx( theta_idx, D );
    
    %Identify elements
    if (node_r ~= node_p) && (node_r ~= node_q) 
        drho_k = 0;
    else
        %Obtain data
        x_p = P_aug(:,node_p);
        x_q = P_aug(:,node_q);
        
        drho_k = (x_p(dim_d) - x_q(dim_d)) / norm(x_p-x_q);
        
        if (node_r ~= node_p) && (node_r == node_q)
            drho_k = -drho_k;
        end
        
    end
    
    
    

end
