clear all; close all; clc

%% data

% Syntehtic data
 u = rand(2e4,1)+1i*rand(2e4,1)-0.5-0.5i;
 y = awgn(tanh(2*u),50,'measured');

% Data from a commercial PA measured in a industrial setup.
% The data set used in the paper (below). It contains input/output
% measurement samples - long data set ~1e6 complex-valued samples be patient for processing.
% load('NardaAMP.mat');    % enable this line

%% settings
Npoints = 70;       % number of estimation points in one axis  
delta = 0.01;       % kernel aperture
plot_flag = 1;     

%% identifiaction
Ntr = floor(3*length(u)/5);     % length of training data
utr = u(1:Ntr);
ytr = y(1:Ntr);
[Pn x NMSE_tr] = density_model(utr,ytr,Npoints,delta,plot_flag);
fprintf(' NMSE training density model: \t %2.2f dB \n',NMSE_tr);

%% runnig model
uval = u(Ntr+1:end);
yval = y(Ntr+1:end);
y_mod = run_density(uval,Pn,x);
% ymod will fail (produce Nans) when the span of 'uval' goes beyond 
% the estimated grid 'x'.

NMSE_val = db(norm(y_mod - yval)/norm(yval));   % normalized MSE
fprintf(' NMSE validation density model: \t %2.2f dB \n',NMSE_val);

