function y = KK2(u)
%
%   2-D conical kernel function
%   Y = KK2(U)
%    
%   Input:
%       U: (2 component vector / matrix). Each row in U is the (x,y)
%          x-axis and y-axis components of a measured sample.
%    
%   Output:
%       Y (2 component vector / matrix).  Y = 1 - sqrt(x^2 + y^2).
%          computed only if sqrt(x^2+y^2) < 1. zero otherwise.
%
%

%
%    Efrain Zenteno  /   Zain Ahmed Khan
%    University of Gvle, Sweden
%    The Royal Institute of Technology KTH, Sweden
%    2014/09/04
%

  %  y = zeros(size(u));
    normuu = sqrt(sum((u.^2),2));
    y = (1-normuu).*(normuu<1);        % conical
end