display('------------------- Noise Robustness experiment--------------------');

load network_mat3;

max_iter = 30;
SRNR_ngp_gaussian = zeros(6,max_iter);PSE_ngp_gaussian = zeros(6,max_iter);
SRNR_ngp_binary = zeros(6,max_iter);PSE_ngp_binary = zeros(6,max_iter);
SRNR_dihat_gaussian = zeros(6,max_iter);PSE_dihat_gaussian = zeros(6,max_iter);
SRNR_dihat_binary = zeros(6,max_iter);PSE_dihat_binary = zeros(6,max_iter);

%% ------- NGP- Gaussian case ----------------%%
display('------------------- NGP- Gaussian case--------------------');
[SRNR_ngp_gaussian(1,:),PSE_ngp_gaussian(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(2,:),PSE_ngp_gaussian(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(3,:),PSE_ngp_gaussian(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(4,:),PSE_ngp_gaussian(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(5,:),PSE_ngp_gaussian(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(6,:),PSE_ngp_gaussian(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);

%% ------------NGP- Binary case -------------------%%
display('------------------- NGP- Binary case--------------------');
[SRNR_ngp_binary(1,:),PSE_ngp_binary(1,:)] = comp_distributed_CS_algo(10, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(2,:),PSE_ngp_binary(2,:)] = comp_distributed_CS_algo(20, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(3,:),PSE_ngp_binary(3,:)] = comp_distributed_CS_algo(30, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(4,:),PSE_ngp_binary(4,:)] = comp_distributed_CS_algo(40, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(5,:),PSE_ngp_binary(5,:)] = comp_distributed_CS_algo(50, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(6,:),PSE_ngp_binary(6,:)] = comp_distributed_CS_algo(60, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);

%% ------- DiHaT- Gaussian case ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian(1,:),PSE_dihat_gaussian(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(2,:),PSE_dihat_gaussian(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(3,:),PSE_dihat_gaussian(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(4,:),PSE_dihat_gaussian(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(5,:),PSE_dihat_gaussian(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(6,:),PSE_dihat_gaussian(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);

%% ------------ DiHaT- Binary case -------------------%%
display('------------------- DiHaT- Binary case--------------------');
[SRNR_dihat_binary(1,:),PSE_dihat_binary(1,:)] = comp_distributed_CS_algo(10, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(2,:),PSE_dihat_binary(2,:)] = comp_distributed_CS_algo(20, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(3,:),PSE_dihat_binary(3,:)] = comp_distributed_CS_algo(30, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(4,:),PSE_dihat_binary(4,:)] = comp_distributed_CS_algo(40, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(5,:),PSE_dihat_binary(5,:)] = comp_distributed_CS_algo(50, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(6,:),PSE_dihat_binary(6,:)] = comp_distributed_CS_algo(60, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);

%% -----------------Plotting results --------------------%%
figure;
subplot(1,2,1);
plot([10 20 30 40 50 60],SRNR_ngp_binary(:,end)','x-');hold on;grid on;
plot([10 20 30 40 50 60],SRNR_dihat_binary(:,end)','o-');
legend('NGP','DiHaT');
xlabel('SNR (in dB)');
ylabel('mSENR (in dB)');
title('Binary Sparse Data');

subplot(1,2,2);
plot([10 20 30 40 50 60],SRNR_ngp_gaussian(:,end)','x-');hold on;grid on;
plot([10 20 30 40 50 60],SRNR_dihat_gaussian(:,end)','o-');
legend('NGP','DiHaT');
xlabel('SNR (in dB)');
ylabel('mSENR (in dB)');
title('Gaussian Sparse Data');