display('------------------- Noise Robustness experiment--------------------');

load network_mat3;

max_iter = 30;
SRNR_ngp_gaussian = zeros(2,max_iter);PSE_ngp_gaussian = zeros(2,max_iter);
SRNR_ngp_binary = zeros(2,max_iter);PSE_ngp_binary = zeros(2,max_iter);
SRNR_dihat_gaussian = zeros(2,max_iter);PSE_dihat_gaussian = zeros(2,max_iter);
SRNR_dihat_binary = zeros(2,max_iter);PSE_dihat_binary = zeros(2,max_iter);

%% ------- NGP- Gaussian case ----------------%%
display('------------------- NGP- Gaussian case--------------------');
[SRNR_ngp_gaussian(1,:),PSE_ngp_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(2,:),PSE_ngp_gaussian(2,:)] = comp_distributed_CS_algo(200, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);

%% ------------NGP- Binary case -------------------%%
display('------------------- NGP- Binary case--------------------');
[SRNR_ngp_binary(1,:),PSE_ngp_binary(1,:)] = comp_distributed_CS_algo(30, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_binary(2,:),PSE_ngp_binary(2,:)] = comp_distributed_CS_algo(200, 'Binary', 'ngp', 100, 500, 20,20, network_mat3);

%% ------- DiHaT- Gaussian case ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian(1,:),PSE_dihat_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(2,:),PSE_dihat_gaussian(2,:)] = comp_distributed_CS_algo(200, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);

%% ------------ DiHaT- Binary case -------------------%%
display('------------------- DiHaT- Binary case--------------------');
[SRNR_dihat_binary(1,:),PSE_dihat_binary(1,:)] = comp_distributed_CS_algo(30, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_binary(2,:),PSE_dihat_binary(2,:)] = comp_distributed_CS_algo(200, 'Binary', 'dihat', 100, 500, 20,20, network_mat3);

%% -----------------Plotting results --------------------%%
figure;
subplot(1,2,1);
plot([1:30],SRNR_ngp_binary(1,:),'x-');hold on;grid on;
plot([1:30],SRNR_ngp_binary(2,:),'x--');
plot([1:30],SRNR_dihat_binary(1,:),'o-');
plot([1:30],SRNR_dihat_binary(2,:),'o--');
legend('NGP, SNR = 30dB','NGP, no noise','DiHaT, SNR = 30dB','DiHaT, no noise');
xlabel('Number of iterations');
ylabel('mSENR (in dB)');
title('Binary Sparse Data');

subplot(1,2,2);
plot([1:30],SRNR_ngp_gaussian(1,:),'x-');hold on;grid on;
plot([1:30],SRNR_ngp_gaussian(2,:),'x--');
plot([1:30],SRNR_dihat_gaussian(1,:),'o-');
plot([1:30],SRNR_dihat_gaussian(2,:),'o--');
legend('NGP, SNR = 30dB','NGP, no noise','DiHaT, SNR = 30dB','DiHaT, no noise');
xlabel('Number of iterations');
ylabel('mSENR (in dB)');
title('Gaussian Sparse Data');