display('------------------- Sensitivity to sparsity experiment--------------------');

load network_mat3;

max_iter = 30;
SRNR_ngp_gaussian = zeros(4,max_iter);PSE_ngp_gaussian = zeros(4,max_iter);
SRNR_dihat_gaussian = zeros(4,max_iter);PSE_dihat_gaussian = zeros(4,max_iter);

%% ------- NGP- Gaussian case ----------------%%
display('------------------- NGP- Gaussian case--------------------');
[SRNR_ngp_gaussian(1,:),PSE_ngp_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,18, network_mat3);
[SRNR_ngp_gaussian(2,:),PSE_ngp_gaussian(2,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,20, network_mat3);
[SRNR_ngp_gaussian(3,:),PSE_ngp_gaussian(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,25, network_mat3);
[SRNR_ngp_gaussian(4,:),PSE_ngp_gaussian(4,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'ngp', 100, 500, 20,30, network_mat3);

%% ------- DiHaT- Gaussian case ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian(1,:),PSE_dihat_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,80, network_mat3);
[SRNR_dihat_gaussian(2,:),PSE_dihat_gaussian(2,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(3,:),PSE_dihat_gaussian(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,25, network_mat3);
[SRNR_dihat_gaussian(4,:),PSE_dihat_gaussian(4,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,30, network_mat3);

%% -----------------Plotting results --------------------%%
figure;
plot([1:30],SRNR_ngp_gaussian(1,:),'x-');hold on;grid on;
plot([1:30],SRNR_ngp_gaussian(2,:),'o-');
plot([1:30],SRNR_ngp_gaussian(3,:),'d-');
plot([1:30],SRNR_ngp_gaussian(4,:),'s-');
plot([1:30],SRNR_dihat_gaussian(1,:),'x--');
plot([1:30],SRNR_dihat_gaussian(2,:),'o--');
plot([1:30],SRNR_dihat_gaussian(3,:),'d--');
plot([1:30],SRNR_dihat_gaussian(4,:),'s--');
legend('NGP, Input s=18','NGP, Input s=20','NGP, Input s=25','NGP, Input s=30','DiHaT, Input s=18','DiHaT, Input s=20','DiHaT, Input s=25','DiHaT, Input s=30');
xlabel('Number of iterations');
ylabel('mSENR (in dB)');