% Program for reproducing results in the paper 'Greedy Sparse Learning over Network'
% Comparing the performance between NGP and DiHaT


function [SRNR_disp_iter,PSE_disp_iter] = comp_distributed_CS_algo(SMNR, str_type,algo_type, M, N, K,K_1, network_mat)

max_iter = 30;

% Number of nodes
[num_nodes,~] = size(network_mat);

% No of 'Sensing Matrix' Simulations
NoOfSensingMatrix=33 ;

% No of data points
NoOfData=34;

if strcmp(str_type,'Gaussian')
    Mean_a = 0;
elseif strcmp(str_type,'Binary')
    Mean_a = 100000;
end

% Signal Power
if (Mean_a ~= 100000)
    Signal_P=1;    % Variance of approximately sparse signal
    p=K/N;
    zeta=0.00000000000001;         % in percentage; 'K' samples have (1-zeta) power, and 'N-K' samples have zeta power
    sigma_2= ((1-(zeta/100))*Signal_P)/(p*N) - Mean_a^2;
    gamma_2= ((zeta/100)*Signal_P)/((1-p)*N);
end

TotalData=NoOfSensingMatrix*NoOfData;
num_iter = zeros(1,TotalData);

% MSE error
Recon_error_disp_iter=zeros(TotalData,max_iter);

% For keeping the cardinality of  I_true intersect I_estimate
Card_disp_Mat_iter=zeros(TotalData,max_iter);

tic
data_index=1;

%% ---------- First Loop --------------

for Sensing_instance=1:NoOfSensingMatrix
    
    % Sparse data creation
    if (Mean_a==100000),
        [X U]=SparseDataCreate_ZeroOne(NoOfData,N,K);
        Signal_P=K;
    else
        [X U]=SparseDataCreate_G_to_NonG(NoOfData,N,K,sigma_2,gamma_2,Mean_a);
    end
    
    % measurement matrix
    if ~rem(Sensing_instance,100)
        disp('Creating measurement matrix...');display(Sensing_instance);
    end
    A = randn(M*num_nodes,N);
    %     A = orth(A')';
    for n=1:N
        for node_loop = 1:num_nodes
            A((node_loop-1)*M + 1:node_loop*M,n)= ...
                A((node_loop-1)*M + 1:node_loop*M,n)/norm(A((node_loop-1)*M + 1:node_loop*M,n));
        end
    end
    
    % CS Measurements
    Y= (A * X')';
    
    % Measurement noise simulation
    NoiseMatrix = zeros(NoOfData,M*num_nodes);
    for node_loop = 1:num_nodes,
        sigma_2_measurement_noise = Signal_P / (M*(10^(SMNR/10)));
        Mu_Noise=zeros(M,1); Cov_Noise=diag(sigma_2_measurement_noise*ones(M,1));
        NoiseMatrix(:,(node_loop-1)*M+1:node_loop*M)=mvnrnd(Mu_Noise,Cov_Noise,NoOfData);
    end
    
    % Noisy CS measurements
    Z=Y+NoiseMatrix;
    
    
    %% -------------- Second loop ---------------------
    for i=1:NoOfData
        
        % observations
        y = Z(i,:)';
        
        % ---------------DiSP algo -------------------------
        if strcmp(algo_type,'ngp')
            [xp_disp_iter] = NGP_func(y,A,M,N,K_1,num_nodes,network_mat);
            
            % ---------------DiIHT algo -------------------------
        elseif strcmp(algo_type,'dihat')
            [xp_disp_iter] = DiHaT_func(y,A,M,N,K_1,num_nodes,network_mat);
            
        end
        
        % ---------------- PERFORMANCE CALCULATION --------------------
        
        % reconstruction errors
        [~,num_iter(data_index)] = size(xp_disp_iter);
        error_disp_iter = zeros(1,num_iter(data_index));
        for iter_count = 1:num_iter(data_index)
            error_disp_iter(iter_count) = error_disp_iter(iter_count) + ...
                (norm(repmat(X(i,:),1,num_nodes)-(xp_disp_iter(:,iter_count)).')^2);
        end
        
        Recon_error_disp_iter(data_index,1:num_iter(data_index)) = error_disp_iter;
        if num_iter(data_index) < max_iter
            Recon_error_disp_iter(data_index,num_iter(data_index)+1:end) = ...
                Recon_error_disp_iter(data_index,num_iter(data_index));
        end
        
        % Cardinality of the intersection set of true support and estimated support
        I_true=support_set_eval(X(i,:)',K);
        
        for iter_count = 1:num_iter(data_index)
            for node_loop = 1:num_nodes
                I_est_disp=support_set_eval(xp_disp_iter((node_loop-1)*N+1:node_loop*N,iter_count),K);
                if length(intersect(I_true,I_est_disp)) == K
                    Card_disp_Mat_iter(data_index,iter_count)= Card_disp_Mat_iter(data_index,iter_count)...
                        + 1;%length(intersect(I_true,I_est_disp));
                end
            end
        end
        if num_iter(data_index) < max_iter
            Card_disp_Mat_iter(data_index,num_iter(data_index)+1:end) = ...
                Card_disp_Mat_iter(data_index,num_iter(data_index));
        end
        
        if ~rem(data_index,100)
            disp(data_index);
            temp_vec1 = mean(Recon_error_disp_iter(1:data_index,:),1)/num_nodes;
            temp_vec2 = mean(Card_disp_Mat_iter(1:data_index,:),1)/num_nodes;
            SRNR_inter_result=10*log10(Signal_P./temp_vec1)
            PSE_inter_result = temp_vec2
        end
        
        data_index=data_index+1;
        
    end
    %% end of the Second 'for' loop
    
end
%% end of the First 'for' loop

%% Performance evaluation using signal to reconstruction noise error (SRNR)
% in dB
avg_Recon_error_disp_iter=mean(Recon_error_disp_iter,1)/num_nodes;
SRNR_disp_iter=-10*log10(avg_Recon_error_disp_iter./Signal_P);


%% Performance evaluation using the intersection set of true support and
%% estimated support
% in ratio
avg_Card_disp_iter=mean(Card_disp_Mat_iter,1)/num_nodes;
PSE_disp_iter=avg_Card_disp_iter;

toc
return