% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ x_hat, I, r ] = ipp_omp( y, A, Kmax, Tini )
[~, N] = size(A);

%% Initialization
yr = y;
T  = [];
l = 1;

%% Iteration
while 1
    %% Make the old values old
    T_old = T;
    yr_old = yr;
    
    %% Create the union with T_old and A*yr_old
    % Tp = max_indices(A'*yr_old, min(l,Kmax));
    Tp = max_indices(A'*yr_old, 1);
    Gamma_tilde = union(T_old, Tp);
    
    %% xp
    xt = zeros(1,N);
    xt_dummy = A(:,Gamma_tilde)\y;
    xt(Gamma_tilde) = xt_dummy;
    
    %% Get The new T as the biggest values in xp
    T_acute = max_indices(xt, min(l,Kmax));
    
	Gamma_check = union(T_acute, Tini);
	
	xch = zeros(1,N);
    xch_dummy = A(:,Gamma_check)\y;
    xch(Gamma_check) = xch_dummy;
	
	%% Get The new T as the biggest values in xp
    T = max_indices(xch, min(l,Kmax));
	
	%% Update residual
    yr = resid(y, A(:,T));
    
	%% update iteration counter
	l = l + 1;
	
    %% If yr>yr_old, quit
    if(norm(yr) >= norm(yr_old)) && (l > Kmax+1)
       T = T_old;
       yr = yr_old;
       break;
    end
end

%% Done
xp = A(:,T)\y;
x_hat = zeros(N,1);
x_hat(T) = xp;
I = T;
r = yr;
end




