function [x_hat, I_BP, r_BP ]=simple_BP(y, A, Kmax, epsilon)

[~ , var_size] = size(A); 
cvx_begin quiet
    variable x_sol(var_size);
    minimize( norm(x_sol,1));
    subject to
    norm(y - A*x_sol,2) <= epsilon;
cvx_end

x_hat = zeros(1,var_size);
    I_BP = max_indices(x_sol, Kmax);
    x_hat(I_BP) = x_sol(I_BP);
    r_BP = resid(y, A(:,I_BP));