% For finding the support set of a sparse signal
% Finds the 'K' indices corresponding to the largest amplitude coeffs of an approximetely sparse vector 'X'

% Written by: Saikat Chatterjee of KTH
% Email: saikatchatt@gmail.com
% Created: 5'th May 2010

function [I_support I_support_compliment]=support_set_eval(xp,K)

% Input
% xp -> Appriximately sparse signal (or, a strictly sparse signal)
% K -> The number of predominant coeffs of appriximately sparse signal (or the number of non-zero coeffs of 
%      strictly sparse signal)

% Output
% I_support -> Support set of cardinality K
% I_support_compliment -> Compliment of the support set (So the cardinality is (N-K))

N=length(xp);

abs_xp=abs(xp);


[Y I]=sort(abs_xp,'descend');

I_support=I(1:K);
I_support_compliment=I(K+1:end);