function A = generate_ref_kmer_vector_taxy(infile,NoRefSpecies,seq2species,k)

    % k is set 3, 4, 5 or 6 as the kmer.
    
    
     
    %% 
    % Reading the fasta reference file and making long sequence by
    % concatenation sub-sequences
    reference_seqs = fastaread(infile);
    
    n = size(reference_seqs,1);
    
    LongRefSeq = cell(NoRefSpecies,1);
    
    for i = 1:n
        
        disp(reference_seqs(i,1).Header);
        
        LongRefSeq{seq2species(i),1} = [LongRefSeq{seq2species(i),1} reference_seqs(i,1).Sequence];
        
    end
    
    
    %%
    % Now we compute kmers
    A = zeros(4^k,NoRefSpecies);
%    size(A)
    
    for j = 1:NoRefSpecies
%         A(:,j) = statistics_kmer_saikat(LongRefSeq{j,1},k);
        
        % Following taxy supplementary
        A(:,j) = statistics_nmer_taxy(LongRefSeq{j,1},k);
        A(:,j) = A(:,j) / (length(LongRefSeq{j,1})-k+1);
    end
    
%    sum(A)
%    pause
    
end
    
 