function nmer_vector = statistics_nmer_taxy(seq, k)

    nmer_vector = zeros(4^k,1);
    nmer = nmercount(seq, k);
    
    if k == 3
        power = uint16([4^2 4 1]);
    elseif k == 4
        power = uint16([4^3 4^2 4 1]);
    elseif k == 5
        power = uint16([4^4 4^3 4^2 4 1]);
    elseif k == 6
        power = uint16([4^5 4^4 4^3 4^2 4 1]);
    elseif k == 7
        power = uint16([4^6 4^5 4^4 4^3 4^2 4 1]);
    elseif k == 8
        power = uint16([4^8 4^6 4^5 4^4 4^3 4^2 4 1]);
    else
        disp('Warning! The input k is less than 3 or bigger than 8!')
    end
    
    for i = 1:size(nmer(:,1))
        pos = sum(uint16(nt2int(nmer{i,1})-1).*power) + 1;
        nmer_vector(pos) = nmer{i,2};
       
    end
    
    nmer_vector=nmer_vector(1:4^k);  % Saikat adds this line (sometimes kmer_vector size is more than 4^k)
    
%     vector = nmer_vector/sum(nmer_vector);
    
end
