function x = L2_min_L1_constraint(A,b)

%%
% This function considers an optimization problem
% minimize ||b - Ax||_2 subject to x >= 0 and ||x||_1 = 1

[~,m] = size(A);

cvx_begin quiet
    variable x(m,1)
    minimize(norm(b - A*x,2))
        subject to 
            x >= 0
            sum(x) == 1
cvx_end            

