% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I, x_hat, r ] = modOMP( y, A, Kmax, I0 )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here
[~, N] = size(A);

I = I0;
xp = A(:,I)\y;
r = y - A(:,I)*xp;
while(1)
    r_old = r;
    I_old = I;
    [~, index] = max(abs(A'*r));
    I = union(I, index);
    xp = A(:,I)\y;
    r = y - A(:,I)*xp;
    if(norm(r) >= norm(r_old) || length(I) > Kmax)
        I = I_old;
        r = r_old;
        break;
    end
end

x_hat = zeros(N,1);
xp = A(:,I)\y;
x_hat(I) = xp;
%length(I)
end




