% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I_cell, x_cell, r_cell ] = nodfrogs( A_cell, y_cell, Kp, Kc, num_usr )

[M,N] = size(A_cell{1});

I_cell  = cell(1, num_usr);
x_cell  = cell(1, num_usr);
r_cell  = cell(1, num_usr);

%% Do some initialization

% this is for implementing the stopping criterion as proposed by the paper
users = 1:num_usr;

%for each user, run the regular SP
for t1 = users
  [I_cell{t1}, x_cell{t1}, r_cell{t1}] ...
    = frogs(y_cell{t1}, A_cell{t1}, Kp+Kc, []);
end
 
%% Maybe some post-processing is needed


end

