% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%%

clf, clear all;

num_usr = 10;
M = 40:5:150;
N = 500;

sp_avg_full = [];
omp_avg_full = [];
frogs_avg_full = [];

dsp_avg_full = [];
domp_avg_full = [];
dfrogs_avg_full = [];

load('simulation_40to65SMNR20binary0.mat');
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
load('../bin020/simulation_40to65SMNR20binary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];

load('simulation_70to95SMNR20binary0.mat');
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
load('../bin020/simulation_70to95SMNR20binary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];

load('simulation_100to120SMNR20binary0.mat');
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
load('../bin020/simulation_100to120SMNR20binary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];

load('simulation_125to150SMNR20binary0.mat');
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
load('../bin020/simulation_125to150SMNR20binary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];

figure(1), clf
for t1 = 2:num_usr
    plot(M/N, dfrogs_avg_full(:,2,t1), 'b','LineWidth',1), hold on,
end
plot(M/N, frogs_avg_full(:,2), 'b-','LineWidth',3), hold on,
xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
axis([0.1 0.20 0 20])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(1), 'Position', [100, 100, 560, 420])

figure(2), clf
for t1 = 2:num_usr
    plot(M/N, domp_avg_full(:,2,t1), 'g','LineWidth',1), hold on,
end
plot(M/N, omp_avg_full(:,2), 'g-','LineWidth',3), hold on,
xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
axis([0.1 0.20 0 20])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(2), 'Position', [100, 100, 560, 420])

figure(3), clf
for t1 = 2:num_usr
    plot(M/N, dsp_avg_full(:,2,t1), 'r','LineWidth',1), hold on,
end
plot(M/N, sp_avg_full(:,2), 'r-','LineWidth',3), hold on,
xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
axis([0.1 0.20 0 20])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(3), 'Position', [100, 100, 560, 420])