% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

clf, clear all;

M = 40:5:150;
N = 500;

dsp_avg_full = [];
domp_avg_full = [];
dfrogs_avg_full = [];
drandsp_avg_full = [];
drandomp_avg_full = [];
drandfrogs_avg_full = [];

load('simulation_40to65SMNR20binary1.mat');
dsp_avg_full = [dsp_avg_full ; dsp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
drandsp_avg_full = [drandsp_avg_full ; drandsp_avg];
drandomp_avg_full = [drandomp_avg_full ; drandomp_avg];
drandfrogs_avg_full = [drandfrogs_avg_full ; drandfrogs_avg];

load('simulation_70to95SMNR20binary1.mat');
dsp_avg_full = [dsp_avg_full ; dsp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
drandsp_avg_full = [drandsp_avg_full ; drandsp_avg];
drandomp_avg_full = [drandomp_avg_full ; drandomp_avg];
drandfrogs_avg_full = [drandfrogs_avg_full ; drandfrogs_avg];

load('simulation_100to120SMNR20binary1.mat');
dsp_avg_full = [dsp_avg_full ; dsp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
drandsp_avg_full = [drandsp_avg_full ; drandsp_avg];
drandomp_avg_full = [drandomp_avg_full ; drandomp_avg];
drandfrogs_avg_full = [drandfrogs_avg_full ; drandfrogs_avg];

load('simulation_125to150SMNR20binary1.mat');
dsp_avg_full = [dsp_avg_full ; dsp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];
drandsp_avg_full = [drandsp_avg_full ; drandsp_avg];
drandomp_avg_full = [drandomp_avg_full ; drandomp_avg];
drandfrogs_avg_full = [drandfrogs_avg_full ; drandfrogs_avg];

figure(1),clf,
plot(M/N, domp_avg_full(:,1), 'g-s','LineWidth',1), hold on,
plot(M/N, dsp_avg_full(:,1), 'r--s','LineWidth',1), hold on,
plot(M/N, dfrogs_avg_full(:,1), 'b-.s','LineWidth',1), hold on,
plot(M/N, drandomp_avg_full(:,1), 'g-o','LineWidth',1), hold on,
plot(M/N, drandsp_avg_full(:,1), 'r--o','LineWidth',1), hold on,
plot(M/N, drandfrogs_avg_full(:,1), 'b-.o','LineWidth',1), hold on,
legend('DiOMP(C_2)', 'DiSP(C_2)','DiFROGS(C_2)','DiOMP(C_{2,rand})', 'DiSP(C_{2,rand})','DiFROGS(C_{2,rand})','Location','NorthEast')
xlabel('\alpha [M/N]'),
ylabel('ASCE'), grid on,
axis([0.1 0.26 0 0.9])
set(gca, 'LooseInset', [0,0,0,0])

figure(2),clf,
plot(M/N, domp_avg_full(:,2), 'g-s','LineWidth',1), hold on,
plot(M/N, dsp_avg_full(:,2), 'r--s','LineWidth',1), hold on,
plot(M/N, dfrogs_avg_full(:,2), 'b-.s','LineWidth',1), hold on,
plot(M/N, drandomp_avg_full(:,2), 'g-o','LineWidth',1), hold on,
plot(M/N, drandsp_avg_full(:,2), 'r--o','LineWidth',1), hold on,
plot(M/N, drandfrogs_avg_full(:,2), 'b-.o','LineWidth',1), hold on,
legend('DiOMP(C_2)', 'DiSP(C_2)','DiFROGS(C_2)','DiOMP(C_{2,rand})', 'DiSP(C_{2,rand})','DiFROGS(C_{2,rand})','Location','NorthWest')
xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
axis([0.14 0.3 0 30])
set(gca, 'LooseInset', [0,0,0,0])

set(figure(1), 'Position', [100, 100, 594, 420])
set(figure(2), 'Position', [100, 100, 594, 420])



