% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I_cell, x_cell, r_cell ] = domp( C, A_cell, y_cell, Kp, Kc, num_usr )

[M,N] = size(A_cell{1});

I_cell  = cell(1, num_usr);
x_cell  = cell(1, num_usr);
r_cell  = cell(1, num_usr);
Ic_cell = cell(1, num_usr);

I_cell_old  = cell(1, num_usr);
x_cell_old  = cell(1, num_usr);
r_cell_old  = cell(1, num_usr);

%% Do some initialization

% this is for implementing the stopping criterion as proposed by the paper
users = 1:num_usr;

%for each user, run the regular SP
for t1 = users
  [I_cell{t1}, x_cell{t1}, r_cell{t1}] ...
    = modOMP(y_cell{t1}, A_cell{t1}, Kp+Kc, []);
end

%% Do the looping with appropriate stopping criterion
for l1 = 1:Kc

  % we are now ready for the next iteration
  for t1 = users
    I_cell_old{t1} = I_cell{t1};
    x_cell_old{t1} = x_cell{t1};
    r_cell_old{t1} = r_cell{t1};
  end
  
  % achieve an estimate for the common support set for each user
  for t1 = users
    % get the s for each user
    s = zeros(N,1);
    for c = 1:num_usr % here we need to check all users
      if(C(t1, c) == 1)
        s(I_cell{c}) = s(I_cell{c}) + 1;
      end
    end
    
    % now get the estimate of the common support (size l1)
    Ic_cell{t1} = max_indices(s, l1);
  end
  
  % now run sp for each user with support-set estimate
  for t1 = users
  [I_cell{t1}, x_cell{t1}, r_cell{t1}] ...
    = modOMP(y_cell{t1}, A_cell{t1}, Kp+Kc, Ic_cell{t1});
  end
    
end

%% Maybe some post-processing is needed


end

