% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I_cell, x_cell, r_cell ] = dsp( C, A_cell, y_cell, Kp, Kc, num_usr )

[M,N] = size(A_cell{1});

I_cell  = cell(1, num_usr);
x_cell  = cell(1, num_usr);
r_cell  = cell(1, num_usr);
Ic_cell = cell(1, num_usr);

I_cell_old  = cell(1, num_usr);
x_cell_old  = cell(1, num_usr);
r_cell_old  = cell(1, num_usr);

%% Do some initialization
k = 0;
% this is for implementing the stopping criterion as proposed by the paper
users = 1:num_usr;

%for each user, run the regular SP
for t1 = users
  [I_cell{t1}, x_cell{t1}, r_cell{t1}] ...
    = modSP(A_cell{t1}, y_cell{t1}, Kp+Kc, []);
end

%% Do the looping with appropriate stopping criterion
while(true)
  k = k + 1;
  %disp(['SP iter:' num2str(k)]);
  % we are now ready for the next iteration
  for t1 = users
    I_cell_old{t1} = I_cell{t1};
    x_cell_old{t1} = x_cell{t1};
    r_cell_old{t1} = r_cell{t1};
  end
  
  % achieve an estimate for the common support set for each user
  for t1 = users
    % get the s for each user
    s = zeros(N,1);
    for c = 1:num_usr % here we need to check all users
      if(C(t1, c) == 1)
        s(I_cell{c}) = s(I_cell{c}) + 1;
      end
    end
    
    % now get the estimate of the common support
    Ic_cell{t1} = max_indices(s, Kc);
  end
  
  % now run sp for each user with support-set estimate
  for t1 = users
  [I_cell{t1}, x_cell{t1}, r_cell{t1}] ...
    = modSP(A_cell{t1}, y_cell{t1}, Kp+Kc, Ic_cell{t1});
  end
  
    % for not deviating away from a good solution
  for t1 = users
    if(~isempty(r_cell{t1}) && ~isempty(r_cell_old{t1}) && ...
      norm(r_cell{t1}) > norm(r_cell_old{t1}))
      I_cell{t1} = I_cell_old{t1};
      x_cell{t1} = x_cell_old{t1};
      r_cell{t1} = r_cell_old{t1};    
    end
  end
  
  for t1 = users
    should_continue = 0;
    % residual norm non-decreasing
    if(norm(r_cell{t1}) < norm(r_cell_old{t1}))
      should_continue = 1;
%       disp('bep');
    else
      % and no new support-sets coming in
      for c = 1:num_usr % here we need to check all users
        %setdiff(I_cell{c},I_cell_old{c})
        if((C(t1, c) == 1) && ~isempty(setdiff(I_cell{c},I_cell_old{c})))
          should_continue = 1;
%           disp(['residual norm' num2str(t1)])
%           disp('bop');
        end
      end
    end
    if(should_continue == 0)
      users = setdiff(users, t1);
    end
  end
  
  %users
  
  if(isempty(users))
    I_cell = I_cell_old;
    x_cell = x_cell_old;
    r_cell = r_cell_old;
    break;
  end
  
end

%% Maybe some post-processing is needed


end

