% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I_hat, x_hat, r_hat ] = frogs( y, A, Kmax, I0 )
[~, N] = size(A);

r = cell(Kmax + 2, 1);
I = cell(Kmax + 2, 1);
x = cell(Kmax + 2, 1);

[I0, ~, ~] = modOMP(y, A, Kmax, I0);

k =length(I0) + 1;

xa = zeros(N,1);
xp = A(:,I0)\y;
xa(I0) = xp;
for i = 1:k
  I{i} = max_indices(xa, i-1);
  r{i} = resid(y, A(:,I{i}));
end
while(1)
  [~, index] = max(abs(A'*r{k}));
  I{k+1} = union(I{k}, index);
  r{k+1} = resid(y, A(:,I{k+1}));

  while(k >= 1)
    x0 = zeros(N,1);
    xp = A(:,I{k+1})\y;
    x0(I{k+1}) = xp;
    Ik = max_indices(x0, k-1);
    rk = resid(y, A(:,Ik));
    
    if(norm(rk) < norm(r{k})) %k = Kmax means Kmax-1
      I{k} = Ik;
      r{k} = rk;
      k = k - 1;
    else
      break;
    end
  end

  k = k + 1;
  
  if(k > Kmax+1)
    break;
  end
end

I_hat = I{k-1};
r_hat = norm(r{k-1});
x_hat = zeros(N, 1);
xp = A(:,I_hat)\y;
x_hat(I_hat) = xp;
end




