% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ I, x_hat, r ] = modSP( A, y, Kmax, I0 )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here
[~, N] = size(A);

%% Initialization
T = max_indices(A'*y, Kmax);
T = union(T, I0);

%% xp
xp = zeros(1,N);
xp_active = A(:,T)\y;
xp(T) = xp_active;

%% Get The new T as the biggest values in xp
T = max_indices(xp, Kmax);

yr = resid(y, A(:,T));

%% Iteration
while(true)
    %% Make the old values old
    T_old = T;
    yr_old = yr;
    
    %% Create the union with T_old and A*yr_old
    Tp = max_indices(A'*yr_old, Kmax);
    T = union(T_old, Tp);
    
    %% xp
    xp = zeros(1,N);
    xp_dummy = A(:,T)\y;
    xp(T) = xp_dummy;
    
    %% Get The new T as the biggest values in xp
    T = max_indices(xp, Kmax);
    
    %% Update residual
    yr = resid(y, A(:,T));
    
    %% If yr>yr_old, quit
    if(norm(yr) >= norm(yr_old))
       T = T_old;
       yr = yr_old;
       break;
    end
end

%% Done
xp = A(:,T)\y;
x_hat = zeros(N,1);
x_hat(T) = xp;
I = T;
r = yr;
end




