% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

clf, clear all;

M = 40:5:150;
N = 500;

sp_avg_full = [];
jsp_avg_full = [];
dsp_avg_full = [];
omp_avg_full = [];
jomp_avg_full = [];
domp_avg_full = [];
frogs_avg_full = [];
jfrogs_avg_full = [];
dfrogs_avg_full = [];


load('simulation_40to65SMNRInfbinary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
jsp_avg_full = [jsp_avg_full ; jsp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
jomp_avg_full = [jomp_avg_full ; jomp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];
jfrogs_avg_full = [jfrogs_avg_full ; jfrogs_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];

load('simulation_70to95SMNRInfbinary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
jsp_avg_full = [jsp_avg_full ; jsp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
jomp_avg_full = [jomp_avg_full ; jomp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];
jfrogs_avg_full = [jfrogs_avg_full ; jfrogs_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];

load('simulation_100to120SMNRInfbinary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
jsp_avg_full = [jsp_avg_full ; jsp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
jomp_avg_full = [jomp_avg_full ; jomp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];
jfrogs_avg_full = [jfrogs_avg_full ; jfrogs_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];

load('simulation_125to150SMNRInfbinary0.mat');
sp_avg_full = [sp_avg_full ; sp_avg];
jsp_avg_full = [jsp_avg_full ; jsp_avg];
dsp_avg_full = [dsp_avg_full ; dsp_avg];
omp_avg_full = [omp_avg_full ; omp_avg];
jomp_avg_full = [jomp_avg_full ; jomp_avg];
domp_avg_full = [domp_avg_full ; domp_avg];
frogs_avg_full = [frogs_avg_full ; frogs_avg];
jfrogs_avg_full = [jfrogs_avg_full ; jfrogs_avg];
dfrogs_avg_full = [dfrogs_avg_full ; dfrogs_avg];

figure(1),clf,
plot(M/N, omp_avg_full(:,1), 'g-^','LineWidth',1), hold on,
plot(M/N, jomp_avg_full(:,1), 'g-o','LineWidth',1), hold on,
plot(M/N, domp_avg_full(:,1), 'g-s','LineWidth',1), hold on,
plot(M/N, sp_avg_full(:,1), 'r--^','LineWidth',1), hold on,
plot(M/N, jsp_avg_full(:,1), 'r--o','LineWidth',1), hold on,
plot(M/N, dsp_avg_full(:,1), 'r--s','LineWidth',1), hold on,
plot(M/N, frogs_avg_full(:,1), 'b-.^','LineWidth',1), hold on,
plot(M/N, jfrogs_avg_full(:,1), 'b-.o','LineWidth',1), hold on,
plot(M/N, dfrogs_avg_full(:,1), 'b-.s','LineWidth',1), hold on,
legend('OMP','JOMP','DiOMP','SP','JSP','DiSP','FROMP','JFROMP','DiFROMP','Location','NorthEast'),
xlabel('\alpha [M/N]'),
ylabel('ASCE'), grid on,
axis([0.08 0.18 0 0.8])
set(gca, 'LooseInset', [0,0,0,0])

figure(2),clf,
plot(M/N, omp_avg_full(:,2), 'g-^','LineWidth',1), hold on,
plot(M/N, jomp_avg_full(:,2), 'g-o','LineWidth',1), hold on,
plot(M/N, domp_avg_full(:,2), 'g-s','LineWidth',1), hold on,
plot(M/N, sp_avg_full(:,2), 'r--^','LineWidth',1), hold on,
plot(M/N, jsp_avg_full(:,2), 'r--o','LineWidth',1), hold on,
plot(M/N, dsp_avg_full(:,2), 'r--s','LineWidth',1), hold on,
plot(M/N, frogs_avg_full(:,2), 'b-.^','LineWidth',1), hold on,
plot(M/N, jfrogs_avg_full(:,2), 'b-.o','LineWidth',1), hold on,
plot(M/N, dfrogs_avg_full(:,2), 'b-.s','LineWidth',1), hold on,
legend('OMP','JOMP','DiOMP','SP','JSP','DiSP','FROMP','JFROMP','DiFROMP','Location','NorthWest'),
xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
axis([0.1 0.2 0 45])
set(gca, 'LooseInset', [0,0,0,0])

set(figure(1), 'Position', [100, 100, 594, 420])
set(figure(2), 'Position', [100, 100, 594, 420])


