% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [] = fig2_simulation_launcher(M)
%% launcher platform for simulations providing data for fig2
num_vec = 100;
num_mat = 100;
num_usr = 10;
binary = 0; % Gaussian sparse signal
SMNR = 20;  % SMNR 20
N = 500;
Kc = 10;
Kp = 10;

dsp_avg = zeros(length(M), 4, num_usr);
dfrogs_avg = zeros(length(M), 4, num_usr);
domp_avg = zeros(length(M), 4, num_usr);


%% Generate connection matrices
C_cell = cell(num_usr, 1);
C = eye(num_usr, num_usr); % corresponds to a regular CS set-up
C_cell{1} = C;
for t1 = 2:num_usr
   C_cell{t1} = C_cell{t1-1}|circshift(C, [-(t1-1) 0]);
end

%% run the actual simulations
for nusr = 1:num_usr
    C = C_cell{nusr};
    for m = 1:length(M)
      disp(['progress: ' ...
          num2str(((nusr-1)/num_usr + (m-1)/(length(M)*num_usr))*100)...
          '%']);
      use_m = M(m);
      [ dsp_avg(m,:,nusr), ...
        dfrogs_avg(m,:,nusr), ...
        domp_avg(m,:,nusr) ] ...
          = fig2_simulation(use_m, num_vec, num_mat, num_usr, C, binary, SMNR, N, Kc, Kp);
    end
end

filename = ['./data/bin020sweep/simulation_' int2str(min(M)) 'to' ...
            int2str(max(M)) 'SMNR' int2str(SMNR) 'binary' ...
            int2str(binary) '.mat'];
        
save(filename, 'dsp_avg', ...
               'dfrogs_avg', ...
               'domp_avg','C');

end