% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [] = fig3_simulation_launcher(M, binary, SMNR)
num_vec = 100;
num_mat = 100;
num_usr = 10;
N = 500;
Kc = 10;
Kp = 10;

sp_avg = zeros(length(M), 4);
dsp_avg = zeros(length(M), 4);
drandsp_avg = zeros(length(M), 4);

frogs_avg = zeros(length(M), 4);
dfrogs_avg = zeros(length(M), 4);
drandfrogs_avg = zeros(length(M), 4);

omp_avg = zeros(length(M), 4);
domp_avg = zeros(length(M), 4);
drandomp_avg = zeros(length(M), 4);

%% Generate connection matrix of degree 2
conns = 3;

tstart = tic;
for m = 1:length(M)
  disp(['progress: ' num2str(round((m-1)/length(M)*100)) '%']);
  use_m = M(m);
  [ sp_avg(m,:),     dsp_avg(m,:),     drandsp_avg(m,:), ...
    frogs_avg(m,:),  dfrogs_avg(m,:),  drandfrogs_avg(m,:), ...
    omp_avg(m,:),    domp_avg(m,:),    drandomp_avg(m,:) ] ...
      = fig3_simulation(use_m, num_vec, num_mat, num_usr, conns, binary, SMNR, N, Kc, Kp);
end
toc(tstart)

filename = ['./data/rand_bin' int2str(binary) int2str(SMNR) ...
            '/simulation_' int2str(min(M)) 'to' ...
            int2str(max(M)) 'SMNR' int2str(SMNR) 'binary' ...
            int2str(binary) '.mat'];
        
save(filename, 'drandsp_avg', 'dsp_avg', ...
               'drandfrogs_avg','dfrogs_avg', ...
               'drandomp_avg','domp_avg', 'conns');



end