function [ I_cell, x_cell, r_cell, dipp_meas ] = dipp( C, A_cell, y_cell, K, num_usr, dipp_meas, nusr, x_true )

[M,N] = size(A_cell{1});
iter_max = 200;

%% Initialization
I_cell  = cell(1, num_usr);
x_cell  = cell(1, num_usr);
r_cell  = cell(1, num_usr);
I_cell_old  = cell(1, num_usr);
x_cell_old  = cell(1, num_usr);
r_cell_old  = cell(1, num_usr);
I_neigh_cell = cell(1, num_usr); %% cell in cell
T_c_hat = cell(1, num_usr);
T_c_hat_old = cell(1, num_usr);
T_ini_cell = cell(1, num_usr);

users = 1:num_usr;

%% Run IPP
for t1 = users
	[I_cell{t1}, x_cell{t1}, r_cell{t1}, l] ...
		= ipp(A_cell{t1}, y_cell{t1}, K, []);
	dipp_meas = dipp_meas.update_inner(l);
end

%% Iterate %%
k = 0;
while(true)
	k = k+1; % users are synchronized so OK to have one counter
	for t1 = users
		I_cell_old{t1} = I_cell{t1};
		T_c_hat_old{t1} = T_c_hat{t1};
		x_cell_old{t1} = x_cell{t1};
		r_cell_old{t1} = r_cell{t1};
	end
	disp(users)
	%% Transmit
	%% Receive
	%% Get a cell with support-sets
	for t1 = users
		% get the s for each user
		s = zeros(N,1);
		k1 = 0;
		a = cell(1, sum(C(t1,:))-1);
		for c = 1:num_usr % here we need to check all users
			if( (C(t1, c) == 1) && (c ~= t1) )
				k1 = k1+1;
				a{k1} = I_cell{c};
			end
		end
		
		T_c_hat{t1} = consensus( a, N, K );
	end
	
	%% Merger
	for t1 = users
		[T_inih, Ih] = merger(x_cell{t1}, T_c_hat{t1}, K);
		% For measurement
		T_ini_cell{t1} = T_inih;
		Jh_old = setdiff(I_cell_old{t1}, Ih);
		%disp('stuff');
		%size(Jh_old)
		%size(T_c_hat{t1})
		%disp(['stuff:' num2str(nusr) num2str(k)]);
		dipp_meas = dipp_meas.update_P(k, nusr, T_c_hat{t1}, Jh_old, x_true{t1});
		%dipp_meas.P_hit
	end
	
	%% Run IPP
	for t1 = users
		[I_cell{t1}, x_cell{t1}, r_cell{t1}, q] ...
			= ipp(A_cell{t1}, y_cell{t1}, K, T_ini_cell{t1});
		dipp_meas = dipp_meas.update_inner(q);
	end
	
	for t1 = users
		should_continue = 0;
		% residual norm non-decreasing
		if(norm(r_cell{t1}) < norm(r_cell_old{t1}))
			should_continue = 1;
		else
			if(~isempty(setdiff(T_c_hat{t1}, T_c_hat_old{t1})))
				disp(setdiff(T_c_hat{t1}, T_c_hat_old{t1})');
				should_continue = 1;
			end
			% and no new support-sets coming in1
% 			for c = 1:num_usr % here we need to check all users
% 				if((C(t1, c) == 1) && ...
% 						~isempty(setdiff(I_cell{c},I_cell_old{c})))
% 					should_continue = 1;
% 				end
% 			end
		end
		
		if(k >= iter_max)
			should_continue = 0;
		end
		
		if(should_continue == 0)
			users = setdiff(users, t1);
			dipp_meas = dipp_meas.update_outer(k);
		end
	end
	
	%users
	
	if(isempty(users))
		I_cell = I_cell_old;
		x_cell = x_cell_old;
		r_cell = r_cell_old;
		break;
	end
	
	
end % while(true)
end

