clear, clc;
figure(1), clf, hold on;
%for l1 = [50 500 5000];
for l1 = 1:4;
	if l1 == 1
		N = 100;
		J = 5;
		I = 15;
	elseif l1 == 2
		N = 1000;
		J = 5;
		I = 15;
	elseif l1 == 3
		N = 100;
		J = 15;
		I = 5;
	elseif l1 == 4
		N = 1000;
		J = 15;
		I = 5;
	end
	T = I+J;
	%N = 25*T;
	Q = N-T;
	epsilon = 0:0.001:Q/N;
	
	f1 = 1-epsilon;
	f23_den = ( J/T + epsilon*( 2*I/Q - 2*J/T ) + epsilon.^2*( (J-I)/Q + J/T - T*I/(Q^2) ) );
	%P1 = J/T + epsilon*(I/Q - J/T);
	%f23_den = (1-epsilon).*P1 + T/Q*epsilon.*(1-P1);
	
	f2 = ( J/T + epsilon*(I/Q - 2*J/T) + epsilon.^2*(J/T - I/Q) ) ./ ...
		f23_den;
	f3 = ( J/T - epsilon*2*J/T + epsilon.^2.*(J/T + T*I/Q^2) ) ./ f23_den;

	plot(epsilon, f1, 'k','LineWidth',1.4),
	plot(epsilon, f2, 'b--','LineWidth',1.4),
	plot(epsilon, f3, 'r-.','LineWidth',1.4),
	%plot(epsilon, -(f1-f3), 'k','MarkerSize',15);
	plot(max(epsilon),min(f1),'k.','MarkerSize',15);
end
figure(1),
axis([0 1 0 1]),
% l = legend('Pr$(i \in \mathcal{T}_p | i \in \hat{\mathcal{T}}_p)$', ...
% 	'Pr$(i \in \mathcal{T}_p | i \in \hat{\mathcal{T}}_p, i\in\hat{\mathcal{T}}_q)$', ...
% 	'Pr$(i \in \mathcal{T}_p | i \in \hat{\mathcal{T}}_q, i\in\hat{\mathcal{T}}_r)$', 'Location', 'SouthWest');
% set(l, 'Interpreter', 'Latex'),
l = legend(...
	'aaaaaaaaaaaaaaaaaaaa', ...
	'bbbbbbbbbbbbbbbbbbbb', ...
	'cccccccccccccccccccc', 'Location', 'SouthWest');
%set(l, 'FontSize', 18);
xlabel('\epsilon'),
ylabel('Probability of detect'),
set(gca, 'LooseInset', [0,0,0,0]),
set(figure(1), 'Position', [100, 100, 560, 420]),
grid on,

fontsize = 14;	
x = 0.66; y = 0.21;
rectangle('Position',[x,y,0.02,0.15],'Curvature',[1,1])
annotation('textarrow',[ x-0.09 x+0.02 ],[ y+0.03 y+0.08 ],...
	'String','a','FontSize',14);

x = 0.72; y = 0.23;
rectangle('Position',[x,y,0.02,0.15],'Curvature',[1,1])
annotation('textarrow',[ x-0.02 x+0.02 ],[ y+0.32 y+0.2 ],...
	'String','b','FontSize',14);
	
x = 0.9; y = 0.05;
rectangle('Position',[x,y,0.02,0.15],'Curvature',[1,1])
annotation('textarrow',[ x-0.09 x-0.01 ],[ y+0.1 y+0.11 ],...
	'String','c','FontSize',14);

x = 0.96; y = 0;
rectangle('Position',[x,y,0.02,0.15],'Curvature',[1,1])
annotation('textarrow',[ x-0.08 x ],[ y+0.69 y+0.24 ],...
	'String','d','FontSize',14);
hold off


set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
set(h_xlabel,'FontSize',fontsize);
set(h_ylabel,'FontSize',fontsize);
set(l, 'FontSize', 18);


saveas(gcf, 'data/consensus/consensus.eps', 'psc2');