% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by %fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%%

clear all;

num_usr = 10;
M = 40:5:150;
N = 500;


dipp_outer_loop_full = [];
ipp_outer_loop_full = [];

load('simulation_40to65SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_70to95SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_100to120SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_125to150SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

figure(5), clf
%for t1 = [3 6 10]
plot(0:num_usr-1, dipp_outer_loop_full(5,:), 'k--x','LineWidth',1.4), hold on,
plot(0:num_usr-1, dipp_outer_loop_full(7,:), 'g--x','LineWidth',1.4), hold on,
plot(0:num_usr-1, dipp_outer_loop_full(9,:), 'r-o','LineWidth',1.4), hold on,
%plot(0:num_usr-1, dipp_outer_loop_full(8,:), 'r-o','LineWidth',1.4), hold on,
%plot(0:num_usr-1, dipp_outer_loop_full(9,:), 'b-.d','LineWidth',1.4), hold on,
%plot(0:num_usr-1, dipp_outer_loop_full(11,:), 'b-.d','LineWidth',1.4), hold on,
plot(0:num_usr-1, dipp_outer_loop_full(11,:), 'b-.d','LineWidth',1.4), hold on,
%end
legend(...
	['\alpha = ' num2str(M(5)/N)], ...
	['\alpha = ' num2str(M(7)/N)], ...
	['\alpha = ' num2str(M(9)/N)], ...
	['\alpha = ' num2str(M(11)/N)],...
	'Location', 'NorthWest');
xlabel('Network connectivity C_X'),
ylabel('E[k] (outer\_loop)'), grid on,
%axis([0.08 0.30 0 70])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(5), 'Position', [100, 100, 560, 420])
fontsize = 14;
set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
set(h_xlabel,'FontSize',fontsize);
set(h_ylabel,'FontSize',fontsize);
saveas(gcf, 'bin0SMNR20_outer_loop_all.eps', 'psc2');