% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [] = fig2_simulation_launcher(M,SMNR,binary)
%% launcher platform for simulations providing data for fig2
num_vec = 10;
num_mat = 10;
num_usr = 10;
%binary = 0; % Gaussian sparse signal
%SMNR = 20;  % SMNR 20
N = 1000;
Kc = 15;
Kp = 5;

dipp_outer_loop = zeros(length(M), num_usr);
dipp_inner_loop = zeros(length(M), num_usr);
dipp_outer_loop_squared = zeros(length(M), num_usr);
dipp_inner_loop_squared = zeros(length(M), num_usr);
dipp_SRNR = zeros(length(M), num_usr);
dipp_ASCE = zeros(length(M), num_usr);
dipp_TOC = zeros(length(M), num_usr);

ipp_inner_loop = zeros(length(M), num_usr);
ipp_inner_loop_squared = zeros(length(M), num_usr);
ipp_SRNR = zeros(length(M), num_usr);
ipp_ASCE = zeros(length(M), num_usr);
ipp_TOC = zeros(length(M), num_usr);


%% Generate connection matrices
C_cell = cell(num_usr, 1);
C = eye(num_usr, num_usr); % corresponds to a regular CS set-up
C_cell{1} = C;
for t1 = 2:num_usr
   C_cell{t1} = C_cell{t1-1}|circshift(C, [-(t1-1) 0]);
end

%% run the actual simulations
for nusr = 9:num_usr
    C = C_cell{nusr};
    for m = 1:length(M)
      disp(['progress: ' ...
          num2str(((nusr-1)/num_usr + (m-1)/(length(M)*num_usr))*100)...
          '%']);
      use_m = M(m);
      [ dipp, ipp ] ...
          = fig2_simulation(use_m, num_vec, num_mat, num_usr, C, binary, SMNR, N, Kc, Kp, nusr);
	  
	  dipp_inner_loop_squared(m, nusr) = dipp.inner_loop_squared;
	  dipp_outer_loop_squared(m, nusr) = dipp.outer_loop_squared;
	  dipp_inner_loop(m, nusr) = dipp.inner_loop;
	  dipp_outer_loop(m, nusr) = dipp.outer_loop;
	  dipp_SRNR(m, nusr) = dipp.SRNR_avg;
	  dipp_ASCE(m, nusr) = dipp.ASCE;
	  dipp_TOC(m, nusr) = dipp.TOC;
	  dipp.P_avg
	  
	  
	  ipp_inner_loop(m, nusr) = ipp.inner_loop;
	  ipp_inner_loop_squared(m, nusr) = ipp.inner_loop_squared;
	  ipp_SRNR(m, nusr) = ipp.SRNR_avg;
	  ipp_ASCE(m, nusr) = ipp.ASCE;
	  ipp_TOC(m, nusr) = ipp.TOC;
    end
end

filename = ['./data/bin' int2str(binary) 'SMNR' int2str(SMNR) 'sweep/simulation_' int2str(min(M)) 'to' ...
            int2str(max(M)) 'SMNR' int2str(SMNR) 'binary' ...
            int2str(binary) '.mat'];
        
save(filename, 'dipp_SRNR', 'dipp_ASCE', 'dipp_TOC', 'dipp_inner_loop', 'dipp_outer_loop',...
	'dipp_inner_loop_squared', 'dipp_outer_loop_squared','ipp_SRNR', 'ipp_ASCE', 'ipp_TOC', 'ipp_inner_loop','ipp_inner_loop_squared','C');

end