clear, clc;
addpath algorithms;

%% Set the parameters
N = 50;                           % signal size
M = 7;                            % measurement size
K = 2;                            % non-zero components
SMNR = 20;                        % signal-to-(measurement)-noise ratio
binar_signal = 0;                 % binary/Gaussian
iterations = 100000;                % number of iterations

%% Generate the support-set
%I = round((N-1)*rand(K,1))+1;     % support-set
I = [14, 26];

%% The something
s_pp  = zeros(N,1);

%% The P()
p_pp = 0;

for l1 = 1:iterations
	%% Generate data
	x = create_data(N, I, binar_signal);
	
	%% Generate matrix
	A = create_sensing_matrix(N,M);
	
	%% Generate measurement noise
	if(SMNR < Inf)
		n = randn(M,1);                 % create noise
		n = n/norm(n,2)^2;              % normalize to 1
		n = norm(n,2)^2/(10^(SMNR/10)); % putting proper SMNR
	else
		n = zeros(M,1);
	end

	%% Get the measurement vector
	y = A*x + n;

	%% Solve with SP
	I_pp = ipp(A, y, K, []);
	
	
	%% Update something
	s_pp(I_pp)   = s_pp(I_pp)   + 1;

end

p_pp = p_pp/iterations;

figure(1), clf, stem(s_pp/(sum(s_pp))*K, 'LineWidth', 1.4),
axis([0 N 0 1]),
xl = xlabel('index i (of support-set)'),
%yl = ylabel('Pr$(i \in \hat{T} | i \in [14, 26])$'),
yl = ylabel('aaaaaaaaaaaaaaaaaaa', 'FontSize', 13),
%set(yl, 'Interpreter', 'Latex'),
%set(xl, 'Interpreter', 'Latex'),
set(gca, 'LooseInset', [0,0,0,0]),
set(figure(1), 'Position', [100, 100, 560, 420]),
grid on;