<?php

namespace Chat\Integration;

/**
 * A facade for the conversation data store. Manages all create/read/update/delete operations on 
 * entries in the conversation.
 */
class ConversationStore {

    const FILE_NAME = 'conversation.txt';
    const PATH_TO_APP_ROOT = '/../../../';

    private $path;

    /**
     * Creates a new instance.
     */
    public function __construct() {
        $this->path = __DIR__ . self::PATH_TO_APP_ROOT . self::FILE_NAME;
    }

    /**
     * Appends a new entry to the current conversation.
     * 
     * @param \Chat\Model\Entry $entry The entry to append.
     */
    public function addEntry(\Chat\Model\Entry $entry) {
        \file_put_contents($this->path, \serialize($entry) . ";\n", FILE_APPEND);
    }

    /**
     * @return array The entire conversation as an array of Entry <code>objects</code>. If the
     *                conversation is empty, also the returned array is empty.
     */
    public function getConversation() {
        $entry_strings = \explode(";\n", \file_get_contents($this->path));
        $entries = array();
        foreach ($entry_strings as $entry_string) {
            $entry = \unserialize($entry_string);
            if ($entry instanceof \Chat\Model\Entry) {
                \array_unshift($entries, $entry);
            }
        }
        return $entries;
    }

}
