<?php

namespace Chat\Controller;

/**
 * This is the application's sole controller. All calls from view to lower layers pass through here.
 */
class Controller {

    private $conversation;

    /**
     * Constructs a new instance.
     */
    public function __construct() {
        $this->conversation = new \Chat\Integration\ConversationStore();
    }

    /**
     * Appends a new entry to the current conversation.
     * 
     * @param \Chat\Model\Entry $entry The entry to append.
     */
    public function addEntry(\Chat\Model\Entry $entry) {
        $this->conversation->addEntry($entry);
    }

    /**
     * @return array The entire conversation as an array of Entry <code>objects</code>.
     */
    public function getConversation() {
        return $this->conversation->getConversation();
    }

}
