<?php

namespace Chat\Util;

/**
 * Some utility methods.
 */
final class Util {

    const SYMBOL_PREFIX = "CHAT_";

    private function __construct() {
        
    }

    /**
     * This function should be called first in any PHP page receiving a HTTP request.
     */
    public static function initRequest() {
        spl_autoload_register(function ($class) {
            include 'classes/' . \str_replace('\\', '/', $class) . '.php';
        });

        session_start();
        self::defineHttpParams();
    }

    private static function defineHttpParams() {
        self::defineHttpParam('AUTHOR_KEY', 'nickName');
        self::defineHttpParam('MSG_KEY', 'msg');
    }

    private static function defineHttpParam($param, $value) {
        define(self::SYMBOL_PREFIX . $param, $value);
    }

}
