<!DOCTYPE html>
<html>
    <head>
        <title>Chat program with server, but without JavaScript. Reload page to see new entries.</title>
        <meta charset="UTF-8">
        <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
        <link rel="stylesheet" type="text/css" href="resources/css/reset.css" />
        <!--[if IE 6]><link rel="stylesheet" type="text/css" href="resources/css/ie6.css" /><![endif]-->
        <link rel="stylesheet" type="text/css" href="resources/css/responsive.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/4cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/8cols.css" />
        <link rel="stylesheet" type="text/css" href="resources/css/chat.css" />
    </head>
    <body>
        <header class="section group">
            <?php include 'resources/fragments/header.html'; ?>
        </header>
    <main class="section group">
        <nav class="section group">
            <?php include 'resources/fragments/nav.html'; ?>
        </nav>
        <div class="section group">
            <div class="col span_4_of_4">
                <h1>Chat program with server, but without JavaScript. Reload page to see new entries.</h1>
            </div>
        </div>
        <div class="section group">
            <h2 class="col span_1_of_4">Type Here</h2>
        </div>
        <form action="store-entry.php" method="post">
            <div class="section group">
                <div class="col span_2_of_4">
                    <label for="nickName">Your Nick Name:</label>
                    <input id="nickName" name="nickName" class='text-author'/>
                </div>
            </div>
            <div class="section group">
                <div class="col span_4_of_4">
                    <textarea id= "entry" name="msg" rows = 5
                              placeholder="Write your entry here."></textarea>
                </div>
            </div>
            <div class="section group">
                <div class="col span_1_of_4">
                    <button>Send</button>
                </div>
            </div>
        </form>
        <div class="section group">
            <h2 class="col span_1_of_4">Conversation</h2>
        </div>
        <div class="section group">
            <div class="col span_4_of_4">
                <?php
                if (!empty($conversation)) {
                    foreach ($conversation as $entry) {
                        echo("<p class='author'>" . $entry->getNickName() . ":</p>");
                        foreach ($entry->getMsg() as $line) {
                            echo("<p class='entry'>" . $line . "</p>");
                        }
                    }
                }
                ?>
            </div>
        </div>
        <footer class="section group">
            <?php include 'resources/fragments/footer.html'; ?>
        </footer>
    </main>
</body>
</html>
