function em = build_engine_model(fname, nt)
% em = build_engine_model(fname, nt)
%
% Read engine performance data from Mach/Altitude/Spool speed map 
% generated by GasTurb11.

    % simplified version, assumes only one spool speed stored
    % if no throttle argument present
    if nargin < 2
        nt = 1;
    end

    [valt, vmach] = parse_inpp(fname);
    em.alt = valt;
    em.mach = vmach;
    
    nalt = numel(em.alt);
    nmach = numel(em.mach);
    em.fn = zeros(nalt, nmach, nt);
    em.sfc = zeros(nalt, nmach, nt);
    
    mk = 1;
    fid = fopen(fname, 'r');
    while ~feof(fid)
        [a,n] = fscanf(fid, '%f %f %f %f', 4);
        if n == 4
           mi = find(valt == a(1));
           mj = find(vmach == a(2));
           em.fn(mi,mj,mk) = a(3);
           em.sfc(mi,mj,mk) = a(4);
           mk = mk + 1;
        else
            fgetl(fid);
        end
        if mk > nt
            mk = 1;
        end
    end
    
end

function [valt, vmach] = parse_inpp(fname)

    valt = [];
    vmach = [];
    fid = fopen(fname, 'r');
    while ~feof(fid)
        [a,n] = fscanf(fid, '%f %f %f %f', 4);
        if n == 4
           valt = [valt; a(1)];
           vmach = [vmach; a(2)];
        else
            fgetl(fid);
        end
    end
    
    valt = unique(sort(valt));
    vmach = unique(sort(vmach));

end
 
