function D = drag(mach, alt)
% D = drag(mach, alt)
%
% Compute the drag of the aircraft at a given Mach number and altitude
%
% mach : Mach number, M = speed / (speed of sound)
% alt  : Altitude in Meter
% D    : drag force, in Newton

    % 110-seat short/medium range, say Bombardier CS-100 
    mass = 50000;      % total aircraft mass (typical cruise)
    S = 80.0;          % wing area
    b = 29.0;          % wing span
   
    % gravity
    g = 9.81;
    
    % TODO: Determine aspect ration from aircraft dimensions
    %  AR = aspect ratio
    AR = replace_me();
    
    % look up atmospheric properties at the given altitude
    [rho,aspeed] = isaatm(alt);
    
    % speed and dynamic pressure
    % TODO: Compute dynamic pressure
    u = aspeed * mach;
    q = replace_me();
    
    % TODO: Compute lift coefficient
    % lift coefficient
    CL = replace_me(); 
    
    if CL > 1.4
        D = NaN;
        return;
    end
    
    % drag estimate
    CD0 = 0.018;
    k = 1 / (0.85 * pi* AR);
   
    % lift-induced drag coefficient
    CDi = k*CL.^2;
   
    % rough wave drag estimate
    Mc = 0.85 - 0.15*CL.^2;
    if mach < Mc
        CDw = 0;
    else
        CDw = 20*(mach - Mc).^4;
    end
    CD = CD0 + CDi + CDw;
    
    % TODO: Compute absolute drag (in Newton)
    D = replace_me();
   
end