function [T,FC] = engine(em, mach, alt)
% [T,SFC] = engine(em, mach, alt)
%
% Return thrust and fuel consumption for the endine model
% stored in em and the given Mach number and altitude.
%
% T   : thrust for one engine, in Newton 
% FC  : fuel consumption, in kg/second, for one engine, at full thrust

    if mach < min(em.mach)
        error('Flying too slow, no engine data for such low speeds!');
    elseif mach > max(em.mach)
        error('Flying too fast, no engine data for such high speeds!');
    end
    
    if alt < min(em.alt)
        error('Flying too low, no engine data at this altitude');
    elseif alt > max(em.alt)
        error('Flying too high, no engine data at this altitude');
    end

    TkN = interp2(em.mach, em.alt, em.fn, mach, alt);
    SFC = interp2(em.mach, em.alt, em.sfc, mach, alt);
    
    % SFC is stored i g/kNs
    FC = TkN * SFC*1e-3;
    T = 1e3*TkN;
    
end
