package se.kth.anderslm.todoes;

import java.util.ArrayList;

import se.kth.anderslm.todoes.model.ToDoItem;

import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListView;

public class MainActivity extends ActionBarActivity {

	private ArrayList<ToDoItem> toDoItems;
	private ArrayAdapter<ToDoItem> adapter;

	private EditText toDoInput;
	private ListView toDoListView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		// Inflate the view from XML
		this.setContentView(R.layout.activity_main);

		// Get references to the user interface components
		toDoInput = (EditText) findViewById(R.id.toDoEditText);
		toDoListView = (ListView) findViewById(R.id.toDoListView);

		// Create an ArrayList for the to-do-items
		toDoItems = new ArrayList<ToDoItem>();
		// Create an ArrayAdapter to bind the ListView to the data
		adapter = new ArrayAdapter<ToDoItem>(this,
				android.R.layout.simple_list_item_1, toDoItems);
		toDoListView.setAdapter(adapter);

		// Register the ListView for this Activity's ContextMen
		this.registerForContextMenu(toDoListView);
	}

	/**
	 * Overriding this Activity's onCreateOptionsMenu method. A ContextMenu for
	 * managing To-DoItems (remove)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	/**
	 * Overriding the Activity's onOptionsItemSelected method. This is where we
	 * define what actions to take when a option menu item is selected.
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		switch (item.getItemId()) {
		case R.id.action_add_todo:
			String text = toDoInput.getText().toString();
			toDoItems.add(new ToDoItem(text));
			adapter.notifyDataSetChanged(); // Update view via the adapter
			toDoInput.setText("");
			return true;
		case R.id.action_cancel:
			toDoInput.setText("");
			return true;
		default:
			// Other alternatives -> default behavior
			return super.onOptionsItemSelected(item);
		}
	}

	/**
	 * Overriding this Activity's onCreateContextMenu method. A ContextMenu for
	 * managing To-Do-Items (remove)
	 */
	@Override
	public void onCreateContextMenu(ContextMenu menu, View view,
			ContextMenu.ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, view, menuInfo);
		getMenuInflater().inflate(R.menu.todo_context_menu, menu);
	}

	/**
	 * Overriding the Activity's onContextItemSelected method. This is where we
	 * define what actions to take when a context menu item is selected.
	 */
	@Override
	public boolean onContextItemSelected(MenuItem item) {

		switch (item.getItemId()) {
		case R.id.action_remove_todo:
			AdapterView.AdapterContextMenuInfo menuInfo;
			menuInfo = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
			int info = menuInfo.position;
			toDoItems.remove(info);
			adapter.notifyDataSetChanged(); // Update view via the adapter
			return true;
		case R.id.action_cancel:
			// Do nothing
			return true;
		default:
			// Other alternatives -> default behavior
			return super.onContextItemSelected(item);
		}
	}

}
