package se.kth.anderslm.lifecycle;

import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.EditText;

/**
 * This class demonstrates when Activity state call backs are executed during
 * the activity's life cycle. Use Logcat to view the Log.i messages. Compare
 * what methods are called when you press the the device's home button and back
 * button respectively. Restart the application through the device's list of
 * applications.
 * Also, tilt the device and view the Logcat output.
 */
public class MainActivity extends ActionBarActivity {
    
	public static final String EDIT_TEXT_STATE = "EDIT_TEXT_STATE";
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Log.i("ActivityLifeCycle", "onCreate called");

		this.setContentView(R.layout.activity_main);
		inputText = (EditText) this.findViewById(R.id.inputText);
	}

	/**
	 * Restore UI state here.
	 */
	@Override
	protected void onRestoreInstanceState(Bundle inState) {
		super.onRestoreInstanceState(inState);
		Log.i("ActivityLifeCycle", "onRestoreInstanceState called");

		// Just an example - this is actually done by default on most View
		// objects.
		String input = inState.getString(EDIT_TEXT_STATE);
		if (input != null)
			inputText.setText(input);
	}

	@Override
	protected void onStart() {
		super.onStart();
		Log.i("ActivityLifeCycle", "onStart called");
	}
	
	@Override
	protected void onRestart() {
		super.onRestart();
		Log.i("ActivityLifeCycle", "onRestart called");
	}


	@Override
	protected void onResume() {
		super.onResume();
		Log.i("ActivityLifeCycle", "onResume called");
	}

	/**
	 * Save UI state here.
	 */
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		Log.i("ActivityLifeCycle", "onSaveInstanceState called");

		// Just an example, this is actually done by default on most View
		// objects.
		String input = inputText.getText().toString();
		outState.putString(EDIT_TEXT_STATE, input);
	}

	/**
	 * Save application state in onPause. After onPause has been called the
	 * application is "killable". Also, stop threads doing (unnecessary) work in
	 * the background (restart in onResume).
	 */
	@Override
	protected void onPause() {
		super.onPause();
		Log.i("ActivityLifeCycle", "onPause called");
	}

	@Override
	protected void onStop() {
		super.onStop();
		Log.i("ActivityLifeCycle", "onStop called");
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.i("ActivityLifeCycle", "onDestroy called");
	}

	private EditText inputText;


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
