package se.kth.anderlm.intents;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class MyMainActivity extends Activity {
	
	Button nextButton;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i("IntentTest", "MainActivity.onCreate");
        setContentView(R.layout.main);
        
        nextButton = (Button) findViewById(R.id.NextButton);
        nextButton.setOnClickListener(new OnNextButtonClick());
    }
    
    private class OnNextButtonClick implements View.OnClickListener {

		public void onClick(View v) {
			Intent intent = new Intent(
					MyMainActivity.this,
					MyOtherActivity.class);
			startActivity(intent);
		}
    }
    
    protected void onStart() {
    	super.onStart();
    	Log.i("IntentTest", "MainActivity.onStart");
    }
    
    protected void onResume() {
    	super.onStart();
    	Log.i("IntentTest", "MainActivity.onResume");
    }
    
    protected void onPause() {
    	super.onPause();
    	Log.i("IntentTest", "MainActivity.onPause");
    }
    
    protected void onStop() {
    	super.onStop();
    	Log.i("IntentTest", "MainActivity.onStop");
    }
    
    protected void onDestroy() {
    	super.onDestroy();
    	Log.i("IntentTest", "MainActivity.onDestroy");
    }
}