package se.kth.andersl.sub;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity {
	
	private static final int SHOW_FORM = 0; // Define request code(s)
	private static final int SHOW_SOMETHING_ELSE = 1;
	
	public static final String NAME = "name";
	public static final String FAVOURITE_NUMBER = "number";
	
	private TextView resultView;
	
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Button button = (Button) findViewById(R.id.StartSubButton);
        button.setOnClickListener(new OnStartSubListener());
        
        resultView = (TextView) findViewById(R.id.ResultView);
    }
    
    private class OnStartSubListener implements View.OnClickListener {
		public void onClick(View v) {
			Intent intent = new Intent(MainActivity.this, SubActivity.class);
			startActivityForResult(intent, SHOW_FORM);
		}
    }
    
    /**
     * Call-back method, called by system when the sub activity
     * returns.
     */
    public void onActivityResult(int requestCode, int resultCode, Intent result) {
    	super.onActivityResult(requestCode, resultCode, result);
    	
    	if(resultCode == Activity.RESULT_OK) {
    		switch(requestCode) {
    			case SHOW_FORM:
    				String name = result.getStringExtra(NAME);
    				int number = result.getIntExtra(FAVOURITE_NUMBER, 42);
    				
    				String output = 
    					"Name entered: " + name + "\nFavourite number: " + number;
    				resultView.setText(output);
    				break;
    			case SHOW_SOMETHING_ELSE:
    				// ...
    				break;
    		}
    	}
    	else {
    		resultView.setText("Sub-Activity canceled");
    	}
    }
}