package se.kth.andersl.sub;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class SubActivity extends Activity {
									
	private EditText editName, editNumber;
	
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.sub);
		
		editName = (EditText) findViewById(R.id.EditName);
		editNumber = (EditText) findViewById(R.id.EditNumber);
		
		Button okButton = (Button) findViewById(R.id.OkButton);
		okButton.setOnClickListener(new OnOkClickListener());
		Button cancelButton = (Button) findViewById(R.id.Cancel);
		cancelButton.setOnClickListener(new OnCancelClickListener());
	}
	
	private class OnOkClickListener implements View.OnClickListener {
		public void onClick(View v) {
			try {
				String name = editName.getText().toString();
				int number = Integer.parseInt(editNumber.getText().toString());
				
				Intent result = new Intent();
				result.putExtra(MainActivity.NAME, name);
				result.putExtra(MainActivity.FAVOURITE_NUMBER, number);
				
				setResult(Activity.RESULT_OK, result);
				finish();
			}
			catch(Exception e) {
				showToast("Invalid input!");
			}
		}
	}
	
	private class OnCancelClickListener implements View.OnClickListener {
		public void onClick(View v) {
			setResult(Activity.RESULT_CANCELED, null);
			finish();
		}	
	}
	
	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}
}
