package se.kth.worker2;

import se.kth.worker2.Prime;
import android.app.Activity;
import android.app.ProgressDialog;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

/** 
 * WorkerThreadExample2
 * An example on how to use a thread to run a heavy task in the background.
 * When the work is done a Handler is used to post back the result to the
 * UI-thread (the only thread that is allowed to update the UI).
 * The heavy task (calculating primes) is defined in an anonymous inner class extending Thread.
 * The task to post back to the UI-thread (update UI) is defined in an anonymous inner class
 * implementing Runnable.
 * 
 * A ProgressDialog is displayed while the background thread is working.
 */
public class WorkerActivity2 extends Activity {
	
	private Button calculateButton;
	private EditText textInput;
	private TextView textOutput;
	private ProgressDialog progressDialog;
	
	private Handler handler;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        calculateButton = (Button) findViewById(R.id.CalculateButton);
        textInput = (EditText) findViewById(R.id.InputEditText);
        textOutput = (TextView) findViewById(R.id.OutputTextView);
       
        // Handler created on UI-thread, hence posted Runnables will be
        // dispatched to that thread.
        handler = new Handler(); 
        
        calculateButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				doWork();
			}
        });
    }
    
    /**
     * This method creates a new thread executing the heavy task and,
     * when the work is done, posts an update back to the UI-thread.
     */
    private void doWork() {
		// Display (indeterminate) progress dialog
		progressDialog = ProgressDialog.show(
				this, "Working..", "Calculating primes", true, false);
		
		String input = textInput.getText().toString();
		final long limit = Long.parseLong(input);
	
		// Create a background thread running the task
		Thread worker = new Thread() {
			public void run() {
	    		final long n = Prime.calculateNumberOfPrimes(limit);
	    		final String output = 
	    			"Number of primes <= " + limit + " equals " + n + EXCLAMATION;

	    		// The work is done, post a new Runnable to update the UI
	    		handler.post(new Runnable() {
	    			public void run() {
	    				progressDialog.dismiss();
	    				textOutput.setText(output);
	    			}
	    		});
			}
		};
		worker.start();
    }
    
    private static final String EXCLAMATION = "\nWow, that's really interesting!";
}