package se.kth.worker3;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

/** 
 * ASyncTaskExample
 * An example on how to use (a sub class to) class ASyncTask<Params, Progress, Result>  
 * to run a heavy task in the background.
 * Override these methods (when necessary):
 * - onPreExecute(), invoked on the UI thread immediately after the task is executed
 * - doInBackground(Params...), invoked on the background thread immediately after onPreExecute finishes
 * - onPostExecute(Result), invoked on the UI thread after the background computation finishes. 
 * The result of the background computation is passed to this step as a parameter.
 * 
 * (See also WorkerExample 1 and 2)
 */
public class WorkerActivity3 extends Activity {
	
	private Button calculateButton;
	private EditText textInput;
	private TextView textOutput;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        calculateButton = (Button) findViewById(R.id.CalculateButton);
        textInput = (EditText) findViewById(R.id.InputEditText);
        textOutput = (TextView) findViewById(R.id.OutputTextView);

        calculateButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calculateButton.setEnabled(false);
				String input = textInput.getText().toString();
				final long limit = Long.parseLong(input);
				
				// Create and execute the background task
				PrimeTask task = new PrimeTask();
				task.execute(limit);
			}
        });
    }
    
    private class PrimeTask extends AsyncTask<Long, Void, String> {
    	
    	/**
    	 * doInBackground - the heavy task (calculate primes).
    	 * This method will be executed on a separate thread.
    	 */
    	protected String doInBackground(Long... limit) {  
    		long lim = limit[0]; // The argument limit is an array
    		long n = Prime.calculateNumberOfPrimes(lim); 
    		String output = "Number of primes <= " + lim + " is " + n; 
    		output += "\nAmazing!";
    		return output;     
    	}         
    	
        /**
         * onPostExecute - update the UI.
         * This method will be executed on the UI-thread.
         */
    	protected void onPostExecute(String output) {  
			textOutput.setText(output); 
			calculateButton.setEnabled(true);
			showToast("Worker thread finished");    
    	}
    }
 
    private void showToast(String msg) {
    	Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
    	toast.show();
    }
}
